/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.adapter.gateway.common.param;

import com.alibaba.csp.sentinel.log.RecordLog;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;

public final class GatewayRegexCache {
    private static final Map<String, Pattern> REGEX_CACHE = new ConcurrentHashMap<String, Pattern>();

    public static Pattern getRegexPattern(String pattern) {
        if (pattern == null) {
            return null;
        }
        return REGEX_CACHE.get(pattern);
    }

    public static boolean addRegexPattern(String pattern) {
        if (pattern == null) {
            return false;
        }
        try {
            Pattern regex = Pattern.compile(pattern);
            REGEX_CACHE.put(pattern, regex);
            return true;
        }
        catch (Exception ex) {
            RecordLog.warn((String)("[GatewayRegexCache] Failed to compile the regex: " + pattern), (Throwable)ex);
            return false;
        }
    }

    public static void clear() {
        REGEX_CACHE.clear();
    }

    private GatewayRegexCache() {
    }
}

