/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.stream.binder.rocketmq.integration.outbound;

import com.alibaba.cloud.stream.binder.rocketmq.custom.RocketMQBeanContainerCache;
import com.alibaba.cloud.stream.binder.rocketmq.properties.RocketMQProducerProperties;
import com.alibaba.cloud.stream.binder.rocketmq.utils.RocketMQUtils;
import java.lang.reflect.Field;
import org.apache.rocketmq.acl.common.AclClientRPCHook;
import org.apache.rocketmq.acl.common.SessionCredentials;
import org.apache.rocketmq.client.hook.CheckForbiddenHook;
import org.apache.rocketmq.client.hook.SendMessageHook;
import org.apache.rocketmq.client.producer.DefaultMQProducer;
import org.apache.rocketmq.client.producer.TransactionMQProducer;
import org.apache.rocketmq.client.trace.AsyncTraceDispatcher;
import org.apache.rocketmq.client.trace.TraceDispatcher;
import org.apache.rocketmq.client.trace.hook.SendMessageTraceHookImpl;
import org.apache.rocketmq.common.UtilAll;
import org.apache.rocketmq.remoting.RPCHook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public final class RocketMQProduceFactory {
    private static final Logger log = LoggerFactory.getLogger(RocketMQProduceFactory.class);

    private RocketMQProduceFactory() {
    }

    public static DefaultMQProducer initRocketMQProducer(String topic, RocketMQProducerProperties producerProperties) {
        SendMessageHook sendMessageHook;
        TransactionMQProducer producer;
        Assert.notNull((Object)producerProperties.getGroup(), (String)"Property 'group' is required - producerGroup");
        Assert.notNull((Object)producerProperties.getNameServer(), (String)"Property 'nameServer' is required");
        AclClientRPCHook rpcHook = null;
        if (StringUtils.hasLength((String)producerProperties.getAccessKey()) && StringUtils.hasLength((String)producerProperties.getSecretKey())) {
            rpcHook = new AclClientRPCHook(new SessionCredentials(producerProperties.getAccessKey(), producerProperties.getSecretKey()));
        }
        if (RocketMQProducerProperties.ProducerType.Trans.equalsName(producerProperties.getProducerType())) {
            producer = new TransactionMQProducer(producerProperties.getNamespace(), producerProperties.getGroup(), rpcHook);
            if (producerProperties.getEnableMsgTrace()) {
                try {
                    AsyncTraceDispatcher dispatcher = new AsyncTraceDispatcher(producerProperties.getGroup(), TraceDispatcher.Type.PRODUCE, producerProperties.getCustomizedTraceTopic(), (RPCHook)rpcHook);
                    dispatcher.setHostProducer(producer.getDefaultMQProducerImpl());
                    Field field = DefaultMQProducer.class.getDeclaredField("traceDispatcher");
                    field.setAccessible(true);
                    field.set(producer, dispatcher);
                    producer.getDefaultMQProducerImpl().registerSendMessageHook((SendMessageHook)new SendMessageTraceHookImpl((TraceDispatcher)dispatcher));
                }
                catch (Throwable e) {
                    log.error("system mq-trace hook init failed ,maybe can't send msg trace data");
                }
            }
        } else {
            producer = new DefaultMQProducer(producerProperties.getNamespace(), producerProperties.getGroup(), (RPCHook)rpcHook, producerProperties.getEnableMsgTrace(), producerProperties.getCustomizedTraceTopic());
        }
        producer.setVipChannelEnabled(null == rpcHook && producerProperties.getVipChannelEnabled());
        producer.setInstanceName(RocketMQUtils.getInstanceName((RPCHook)rpcHook, topic + "|" + UtilAll.getPid()));
        producer.setNamesrvAddr(producerProperties.getNameServer());
        producer.setSendMsgTimeout(producerProperties.getSendMsgTimeout());
        producer.setRetryTimesWhenSendFailed(producerProperties.getRetryTimesWhenSendFailed());
        producer.setRetryTimesWhenSendAsyncFailed(producerProperties.getRetryTimesWhenSendAsyncFailed());
        producer.setCompressMsgBodyOverHowmuch(producerProperties.getCompressMsgBodyThreshold());
        producer.setRetryAnotherBrokerWhenNotStoreOK(producerProperties.getRetryAnotherBroker());
        producer.setMaxMessageSize(producerProperties.getMaxMessageSize());
        producer.setUseTLS(producerProperties.getUseTLS());
        producer.setUnitName(producerProperties.getUnitName());
        CheckForbiddenHook checkForbiddenHook = RocketMQBeanContainerCache.getBean(producerProperties.getCheckForbiddenHook(), CheckForbiddenHook.class);
        if (null != checkForbiddenHook) {
            producer.getDefaultMQProducerImpl().registerCheckForbiddenHook(checkForbiddenHook);
        }
        if (null != (sendMessageHook = RocketMQBeanContainerCache.getBean(producerProperties.getSendMessageHook(), SendMessageHook.class))) {
            producer.getDefaultMQProducerImpl().registerSendMessageHook(sendMessageHook);
        }
        return producer;
    }
}

