/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.dubbo.http.util;

import com.alibaba.cloud.dubbo.http.converter.HttpMessageConverterHolder;
import com.alibaba.cloud.dubbo.metadata.RequestMetadata;
import com.alibaba.cloud.dubbo.metadata.RestMethodMetadata;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpRequest;
import org.springframework.http.MediaType;
import org.springframework.http.converter.GenericHttpMessageConverter;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;

public class HttpMessageConverterResolver {
    private static final MediaType MEDIA_TYPE_APPLICATION = new MediaType("application");
    private final List<HttpMessageConverter<?>> messageConverters;
    private final List<MediaType> allSupportedMediaTypes;
    private final ClassLoader classLoader;

    public HttpMessageConverterResolver(List<HttpMessageConverter<?>> messageConverters, ClassLoader classLoader) {
        this.messageConverters = messageConverters;
        this.allSupportedMediaTypes = this.getAllSupportedMediaTypes(messageConverters);
        this.classLoader = classLoader;
    }

    public HttpMessageConverterHolder resolve(HttpRequest request, Class<?> parameterType) {
        HttpMessageConverterHolder httpMessageConverterHolder = null;
        HttpHeaders httpHeaders = request.getHeaders();
        MediaType contentType = httpHeaders.getContentType();
        if (contentType == null) {
            contentType = MediaType.APPLICATION_OCTET_STREAM;
        }
        for (HttpMessageConverter<?> converter : this.messageConverters) {
            if (converter instanceof GenericHttpMessageConverter) {
                GenericHttpMessageConverter genericConverter = (GenericHttpMessageConverter)converter;
                if (!genericConverter.canRead(parameterType, parameterType, contentType)) continue;
                httpMessageConverterHolder = new HttpMessageConverterHolder(contentType, converter);
                break;
            }
            if (!converter.canRead(parameterType, contentType)) continue;
            httpMessageConverterHolder = new HttpMessageConverterHolder(contentType, converter);
            break;
        }
        return httpMessageConverterHolder;
    }

    public HttpMessageConverterHolder resolve(RequestMetadata requestMetadata, RestMethodMetadata restMethodMetadata) {
        HttpMessageConverterHolder httpMessageConverterHolder = null;
        Class<?> returnValueClass = this.resolveReturnValueClass(restMethodMetadata);
        List<MediaType> requestedMediaTypes = this.getAcceptableMediaTypes(requestMetadata);
        List<MediaType> producibleMediaTypes = this.getProducibleMediaTypes(restMethodMetadata, returnValueClass);
        LinkedHashSet<MediaType> compatibleMediaTypes = new LinkedHashSet<MediaType>();
        for (MediaType requestedType : requestedMediaTypes) {
            for (MediaType mediaType : producibleMediaTypes) {
                if (!requestedType.isCompatibleWith(mediaType)) continue;
                compatibleMediaTypes.add(this.getMostSpecificMediaType(requestedType, mediaType));
            }
        }
        if (compatibleMediaTypes.isEmpty()) {
            return httpMessageConverterHolder;
        }
        ArrayList mediaTypes = new ArrayList(compatibleMediaTypes);
        MediaType.sortBySpecificityAndQuality(mediaTypes);
        MediaType selectedMediaType = null;
        for (MediaType mediaType : mediaTypes) {
            if (mediaType.isConcrete()) {
                selectedMediaType = mediaType;
                break;
            }
            if (!mediaType.equals((Object)MediaType.ALL) && !mediaType.equals((Object)MEDIA_TYPE_APPLICATION)) continue;
            selectedMediaType = MediaType.APPLICATION_OCTET_STREAM;
            break;
        }
        if (selectedMediaType != null) {
            selectedMediaType = selectedMediaType.removeQualityValue();
            for (HttpMessageConverter httpMessageConverter : this.messageConverters) {
                if (!httpMessageConverter.canWrite(returnValueClass, selectedMediaType)) continue;
                httpMessageConverterHolder = new HttpMessageConverterHolder(selectedMediaType, httpMessageConverter);
                break;
            }
        }
        return httpMessageConverterHolder;
    }

    public List<MediaType> getAllSupportedMediaTypes() {
        return Collections.unmodifiableList(this.allSupportedMediaTypes);
    }

    private Class<?> resolveReturnValueClass(RestMethodMetadata restMethodMetadata) {
        String returnClassName = restMethodMetadata.getMethod().getReturnType();
        return ClassUtils.resolveClassName((String)returnClassName, (ClassLoader)this.classLoader);
    }

    private List<MediaType> getAcceptableMediaTypes(RequestMetadata requestMetadata) {
        return requestMetadata.getProduceMediaTypes();
    }

    private List<MediaType> getProducibleMediaTypes(RestMethodMetadata restMethodMetadata, Class<?> returnValueClass) {
        RequestMetadata serverRequestMetadata = restMethodMetadata.getRequest();
        List<MediaType> mediaTypes = serverRequestMetadata.getProduceMediaTypes();
        if (!CollectionUtils.isEmpty(mediaTypes)) {
            return mediaTypes;
        }
        if (!this.allSupportedMediaTypes.isEmpty()) {
            ArrayList<MediaType> result = new ArrayList<MediaType>();
            for (HttpMessageConverter<?> converter : this.messageConverters) {
                if (!converter.canWrite(returnValueClass, null)) continue;
                result.addAll(converter.getSupportedMediaTypes());
            }
            return result;
        }
        return Collections.singletonList(MediaType.ALL);
    }

    private List<MediaType> getAllSupportedMediaTypes(List<HttpMessageConverter<?>> messageConverters) {
        LinkedHashSet allSupportedMediaTypes = new LinkedHashSet();
        for (HttpMessageConverter<?> messageConverter : messageConverters) {
            allSupportedMediaTypes.addAll(messageConverter.getSupportedMediaTypes());
        }
        ArrayList result = new ArrayList(allSupportedMediaTypes);
        MediaType.sortBySpecificity(result);
        return Collections.unmodifiableList(result);
    }

    private MediaType getMostSpecificMediaType(MediaType acceptType, MediaType produceType) {
        MediaType produceTypeToUse = produceType.copyQualityValue(acceptType);
        return MediaType.SPECIFICITY_COMPARATOR.compare(acceptType, produceTypeToUse) <= 0 ? acceptType : produceTypeToUse;
    }
}

