/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.sentinel.rest;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.client.ClientHttpResponse;

public class SentinelClientHttpResponse
implements ClientHttpResponse {
    private String blockResponse = "RestTemplate request block by sentinel";

    public SentinelClientHttpResponse() {
    }

    public SentinelClientHttpResponse(String blockResponse) {
        this.blockResponse = blockResponse;
    }

    public int getRawStatusCode() throws IOException {
        return HttpStatus.OK.value();
    }

    public HttpStatus getStatusCode() throws IOException {
        return HttpStatus.OK;
    }

    public String getStatusText() throws IOException {
        return this.blockResponse;
    }

    public void close() {
    }

    public InputStream getBody() throws IOException {
        return new ByteArrayInputStream(this.blockResponse.getBytes());
    }

    public HttpHeaders getHeaders() {
        HashMap<String, List<String>> headers = new HashMap<String, List<String>>();
        headers.put("Content-Type", Arrays.asList("application/json"));
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.putAll(headers);
        return httpHeaders;
    }
}

