/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.sentinel.custom;

import com.alibaba.cloud.sentinel.annotation.SentinelRestTemplate;
import com.alibaba.cloud.sentinel.custom.BlockClassRegistry;
import com.alibaba.cloud.sentinel.rest.SentinelClientHttpResponse;
import com.alibaba.csp.sentinel.Entry;
import com.alibaba.csp.sentinel.EntryType;
import com.alibaba.csp.sentinel.SphU;
import com.alibaba.csp.sentinel.Tracer;
import com.alibaba.csp.sentinel.slots.block.BlockException;
import com.alibaba.csp.sentinel.slots.block.degrade.DegradeException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.web.client.RestTemplate;

public class SentinelProtectInterceptor
implements ClientHttpRequestInterceptor {
    private final SentinelRestTemplate sentinelRestTemplate;
    private final RestTemplate restTemplate;

    public SentinelProtectInterceptor(SentinelRestTemplate sentinelRestTemplate, RestTemplate restTemplate) {
        this.sentinelRestTemplate = sentinelRestTemplate;
        this.restTemplate = restTemplate;
    }

    public ClientHttpResponse intercept(HttpRequest request, byte[] body, ClientHttpRequestExecution execution) throws IOException {
        Method urlCleanerMethod;
        URI uri = request.getURI();
        String hostResource = request.getMethod().toString() + ":" + uri.getScheme() + "://" + uri.getHost() + (String)(uri.getPort() == -1 ? "" : ":" + uri.getPort());
        Object hostWithPathResource = hostResource + uri.getPath();
        boolean entryWithPath = true;
        if (hostResource.equals(hostWithPathResource)) {
            entryWithPath = false;
        }
        if ((urlCleanerMethod = BlockClassRegistry.lookupUrlCleaner(this.sentinelRestTemplate.urlCleanerClass(), this.sentinelRestTemplate.urlCleaner())) != null) {
            hostWithPathResource = (String)this.methodInvoke(urlCleanerMethod, hostWithPathResource);
        }
        Entry hostEntry = null;
        Entry hostWithPathEntry = null;
        ClientHttpResponse response = null;
        try {
            hostEntry = SphU.entry((String)hostResource, (EntryType)EntryType.OUT);
            if (entryWithPath) {
                hostWithPathEntry = SphU.entry((String)hostWithPathResource, (EntryType)EntryType.OUT);
            }
            response = execution.execute(request, body);
            if (this.restTemplate.getErrorHandler().hasError(response)) {
                Tracer.trace((Throwable)new IllegalStateException("RestTemplate ErrorHandler has error"));
            }
            ClientHttpResponse clientHttpResponse = response;
            return clientHttpResponse;
        }
        catch (Throwable e) {
            if (BlockException.isBlockException((Throwable)e)) {
                ClientHttpResponse clientHttpResponse = this.handleBlockException(request, body, execution, (BlockException)e);
                return clientHttpResponse;
            }
            Tracer.traceEntry((Throwable)e, (Entry)hostEntry);
            if (e instanceof IOException) {
                IOException ioException = (IOException)e;
                throw ioException;
            }
            if (e instanceof RuntimeException) {
                RuntimeException runtimeException = (RuntimeException)e;
                throw runtimeException;
            }
            throw new IOException(e);
        }
        finally {
            if (hostWithPathEntry != null) {
                hostWithPathEntry.exit();
            }
            if (hostEntry != null) {
                hostEntry.exit();
            }
        }
    }

    private ClientHttpResponse handleBlockException(HttpRequest request, byte[] body, ClientHttpRequestExecution execution, BlockException ex) {
        Object[] args = new Object[]{request, body, execution, ex};
        if (this.isDegradeFailure(ex)) {
            Method fallbackMethod = this.extractFallbackMethod(this.sentinelRestTemplate.fallback(), this.sentinelRestTemplate.fallbackClass());
            if (fallbackMethod != null) {
                return (ClientHttpResponse)this.methodInvoke(fallbackMethod, args);
            }
            return new SentinelClientHttpResponse();
        }
        Method blockHandler = this.extractBlockHandlerMethod(this.sentinelRestTemplate.blockHandler(), this.sentinelRestTemplate.blockHandlerClass());
        if (blockHandler != null) {
            return (ClientHttpResponse)this.methodInvoke(blockHandler, args);
        }
        return new SentinelClientHttpResponse();
    }

    private Object methodInvoke(Method method, Object ... args) {
        try {
            return method.invoke(null, args);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private Method extractFallbackMethod(String fallback, Class<?> fallbackClass) {
        return BlockClassRegistry.lookupFallback(fallbackClass, fallback);
    }

    private Method extractBlockHandlerMethod(String block, Class<?> blockClass) {
        return BlockClassRegistry.lookupBlockHandler(blockClass, block);
    }

    private boolean isDegradeFailure(BlockException ex) {
        return ex instanceof DegradeException;
    }
}

