/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.alicloud.context.statistics;

import com.alibaba.alicloud.context.acm.AcmContextBootstrapConfiguration;
import com.alibaba.alicloud.context.acm.AcmProperties;
import com.alibaba.alicloud.context.ans.AnsContextAutoConfiguration;
import com.alibaba.alicloud.context.ans.AnsProperties;
import com.alibaba.alicloud.context.edas.EdasProperties;
import com.alibaba.alicloud.context.oss.OssContextAutoConfiguration;
import com.alibaba.alicloud.context.oss.OssProperties;
import com.alibaba.alicloud.context.scx.ScxContextAutoConfiguration;
import com.alibaba.alicloud.context.scx.ScxProperties;
import com.alibaba.cloud.context.AliCloudServerMode;
import com.alibaba.cloud.context.edas.AliCloudEdasSdk;
import com.alibaba.cloud.context.edas.EdasConfiguration;
import com.alibaba.cloud.context.statistics.StatisticsTask;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.context.annotation.Configuration;

@Configuration
@AutoConfigureAfter(value={ScxContextAutoConfiguration.class, OssContextAutoConfiguration.class, AnsContextAutoConfiguration.class, AcmContextBootstrapConfiguration.class})
public class StatisticsTaskStarter
implements InitializingBean {
    private static final String NACOS_CONFIG_SERVER_MODE_KEY = "spring.cloud.nacos.config.server-mode";
    private static final String NACOS_DISCOVERY_SERVER_MODE_KEY = "spring.cloud.nacos.discovery.server-mode";
    private static final String NACOS_SERVER_MODE_VALUE = "EDAS";
    @Autowired(required=false)
    private AliCloudEdasSdk aliCloudEdasSdk;
    @Autowired(required=false)
    private EdasProperties edasProperties;
    @Autowired(required=false)
    private ScxProperties scxProperties;
    @Autowired(required=false)
    private OssProperties ossProperties;
    @Autowired(required=false)
    private AnsProperties ansProperties;
    @Autowired(required=false)
    private AcmProperties acmProperties;
    @Autowired(required=false)
    private ScxContextAutoConfiguration scxContextAutoConfiguration;
    @Autowired(required=false)
    private OssContextAutoConfiguration ossContextAutoConfiguration;
    @Autowired(required=false)
    private AnsContextAutoConfiguration ansContextAutoConfiguration;
    @Autowired(required=false)
    private AcmContextBootstrapConfiguration acmContextBootstrapConfiguration;

    public void afterPropertiesSet() {
        StatisticsTask statisticsTask = new StatisticsTask(this.aliCloudEdasSdk, (EdasConfiguration)this.edasProperties, this.getComponents());
        statisticsTask.start();
    }

    private List<String> getComponents() {
        boolean acmEnableEdas;
        boolean ansEnableEdas;
        ArrayList<String> components = new ArrayList<String>();
        if (this.scxContextAutoConfiguration != null && this.scxProperties != null) {
            components.add("SC-SCX");
        }
        if (this.ossContextAutoConfiguration != null && this.ossProperties != null) {
            components.add("SC-OSS");
        }
        boolean edasEnabled = this.edasProperties != null && this.edasProperties.isEnabled();
        boolean bl = ansEnableEdas = edasEnabled || this.ansProperties != null && this.ansProperties.getServerMode() == AliCloudServerMode.EDAS;
        if (this.ansContextAutoConfiguration != null && ansEnableEdas) {
            components.add("SC-ANS");
        }
        boolean bl2 = acmEnableEdas = edasEnabled || this.acmProperties != null && this.acmProperties.getServerMode() == AliCloudServerMode.EDAS;
        if (this.acmContextBootstrapConfiguration != null && acmEnableEdas) {
            components.add("SC-ACM");
        }
        if (NACOS_SERVER_MODE_VALUE.equals(System.getProperty(NACOS_CONFIG_SERVER_MODE_KEY))) {
            components.add("SC-NACOS-CONFIG");
        }
        if (NACOS_SERVER_MODE_VALUE.equals(System.getProperty(NACOS_DISCOVERY_SERVER_MODE_KEY))) {
            components.add("SC-NACOS-DISCOVERY");
        }
        return components;
    }
}

