/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.sentinel.datasource.factorybean;

import com.alibaba.csp.sentinel.datasource.Converter;
import com.alibaba.csp.sentinel.datasource.redis.RedisDataSource;
import com.alibaba.csp.sentinel.datasource.redis.config.RedisConnectionConfig;
import java.time.Duration;
import java.util.List;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class RedisDataSourceFactoryBean
implements FactoryBean<RedisDataSource> {
    private String host;
    private int port;
    private int database;
    private Duration timeout;
    private List<String> nodes;
    private Converter converter;
    private String ruleKey;
    private String channel;
    private String password;
    private String masterId;

    public RedisDataSource getObject() {
        RedisConnectionConfig.Builder builder = RedisConnectionConfig.builder();
        if (this.nodes == null || this.nodes.isEmpty()) {
            builder.withHost(this.host).withPort(this.port).withDatabase(this.database);
        } else {
            this.nodes.forEach(node -> {
                try {
                    String[] parts = StringUtils.split((String)node, (String)":");
                    Assert.state((parts.length == 2 ? 1 : 0) != 0, (String)"Must be defined as 'host:port'");
                    builder.withRedisSentinel(parts[0], Integer.parseInt(parts[1]));
                }
                catch (RuntimeException ex) {
                    throw new IllegalStateException("Invalid redis sentinel property " + node, ex);
                }
            });
            builder.withSentinelMasterId(this.masterId);
        }
        if (this.timeout != null) {
            builder.withTimeout(this.timeout.toMillis());
        }
        if (StringUtils.hasText((String)this.password)) {
            builder.withPassword(this.password);
        }
        return new RedisDataSource(builder.build(), this.ruleKey, this.channel, this.converter);
    }

    public Class<?> getObjectType() {
        return RedisDataSource.class;
    }

    public Converter getConverter() {
        return this.converter;
    }

    public void setConverter(Converter converter) {
        this.converter = converter;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getRuleKey() {
        return this.ruleKey;
    }

    public void setRuleKey(String ruleKey) {
        this.ruleKey = ruleKey;
    }

    public String getChannel() {
        return this.channel;
    }

    public void setChannel(String channel) {
        this.channel = channel;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public int getDatabase() {
        return this.database;
    }

    public void setDatabase(int database) {
        this.database = database;
    }

    public Duration getTimeout() {
        return this.timeout;
    }

    public void setTimeout(Duration timeout) {
        this.timeout = timeout;
    }

    public List<String> getNodes() {
        return this.nodes;
    }

    public void setNodes(List<String> nodes) {
        this.nodes = nodes;
    }

    public String getMasterId() {
        return this.masterId;
    }

    public void setMasterId(String masterId) {
        this.masterId = masterId;
    }
}

