/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.commons.io;

import com.alibaba.cloud.commons.io.Charsets;
import com.alibaba.cloud.commons.io.IOUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.Charset;

public final class FileUtils {
    private FileUtils() {
    }

    public static FileInputStream openInputStream(File file) throws IOException {
        if (file.exists()) {
            if (file.isDirectory()) {
                throw new IOException("File '" + file + "' exists but is a directory");
            }
            if (!file.canRead()) {
                throw new IOException("File '" + file + "' cannot be read");
            }
        } else {
            throw new FileNotFoundException("File '" + file + "' does not exist");
        }
        return new FileInputStream(file);
    }

    public static String readFileToString(File file, Charset encoding) throws IOException {
        try (FileInputStream in = FileUtils.openInputStream(file);){
            String string = IOUtils.toString(in, Charsets.toCharset(encoding));
            return string;
        }
    }

    public static String readFileToString(File file, String encoding) throws IOException {
        return FileUtils.readFileToString(file, Charsets.toCharset(encoding));
    }

    @Deprecated
    public static String readFileToString(File file) throws IOException {
        return FileUtils.readFileToString(file, Charset.defaultCharset());
    }
}

