/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.commons.matcher;

import com.alibaba.cloud.commons.lang.StringUtils;
import com.alibaba.cloud.commons.matcher.Matcher;
import com.alibaba.cloud.commons.matcher.StringMatcherType;
import java.util.Locale;
import java.util.regex.Pattern;

public class StringMatcher
implements Matcher {
    private String matcher;
    private StringMatcherType type;
    private boolean isIgnoreCase;
    private String regex;

    public StringMatcher() {
    }

    public StringMatcher(String regex) {
        this.regex = regex;
        this.type = StringMatcherType.REGEX;
    }

    public StringMatcher(String matcher, StringMatcherType type, boolean isIgnoreCase) {
        this.matcher = matcher;
        this.type = type;
        this.isIgnoreCase = isIgnoreCase;
    }

    @Override
    public boolean match(Object obj) {
        if (!(obj instanceof String)) {
            return false;
        }
        String str = (String)obj;
        if (StringUtils.isEmpty(str)) {
            return false;
        }
        if (this.isIgnoreCase) {
            str = str.toLowerCase(Locale.ROOT);
            this.matcher = this.matcher.toLowerCase(Locale.ROOT);
        }
        switch (this.type) {
            case EXACT: {
                return str.equals(this.matcher);
            }
            case PREFIX: {
                return str.startsWith(this.matcher);
            }
            case SUFFIX: {
                return str.endsWith(this.matcher);
            }
            case CONTAIN: {
                return str.contains(this.matcher);
            }
            case REGEX: {
                try {
                    return Pattern.matches(this.regex, str);
                }
                catch (Exception e) {
                    return false;
                }
            }
        }
        throw new UnsupportedOperationException("unsupported string compare operation");
    }

    public String getMatcher() {
        return this.matcher;
    }

    public void setMatcher(String matcher) {
        this.matcher = matcher;
    }

    public StringMatcherType getType() {
        return this.type;
    }

    public void setType(StringMatcherType type) {
        this.type = type;
    }

    public boolean isIgnoreCase() {
        return this.isIgnoreCase;
    }

    public void setIgnoreCase(boolean ignoreCase) {
        this.isIgnoreCase = ignoreCase;
    }

    public String getRegex() {
        return this.regex;
    }

    public void setRegex(String regex) {
        this.regex = regex;
    }
}

