/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.nacos.annotation;

import com.alibaba.cloud.nacos.NacosConfigManager;
import com.alibaba.cloud.nacos.annotation.AbstractConfigChangeListener;
import com.alibaba.cloud.nacos.annotation.NacosConfig;
import com.alibaba.cloud.nacos.annotation.NacosConfigKeysListener;
import com.alibaba.cloud.nacos.annotation.NacosConfigListener;
import com.alibaba.cloud.nacos.annotation.NacosConfigRefreshableListener;
import com.alibaba.cloud.nacos.annotation.NacosPropertiesKeyListener;
import com.alibaba.cloud.nacos.annotation.ObjectUtils;
import com.alibaba.cloud.nacos.annotation.PropertiesUtils;
import com.alibaba.cloud.nacos.annotation.TargetRefreshable;
import com.alibaba.nacos.api.config.ConfigChangeEvent;
import com.alibaba.nacos.api.config.ConfigChangeItem;
import com.alibaba.nacos.api.config.listener.AbstractListener;
import com.alibaba.nacos.api.config.listener.Listener;
import com.alibaba.nacos.client.config.common.GroupKey;
import java.beans.PropertyDescriptor;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.BeansException;
import org.springframework.beans.NotReadablePropertyException;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.PriorityOrdered;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.annotation.MergedAnnotation;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.core.type.MethodMetadata;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class NacosAnnotationProcessor
implements BeanPostProcessor,
PriorityOrdered,
ApplicationContextAware {
    private NacosConfigManager nacosConfigManager;
    private ApplicationContext applicationContext;
    private static final Logger log = LoggerFactory.getLogger(NacosAnnotationProcessor.class);
    private Map<String, TargetRefreshable> targetListenerMap = new ConcurrentHashMap<String, TargetRefreshable>();
    private Map<String, AtomicReference<String>> groupKeyCache = new ConcurrentHashMap<String, AtomicReference<String>>();

    public int getOrder() {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getGroupKeyContent(final String dataId, final String group, boolean refreshed) throws Exception {
        if (this.groupKeyCache.containsKey(GroupKey.getKey((String)dataId, (String)group))) {
            return this.groupKeyCache.get(GroupKey.getKey((String)dataId, (String)group)).get();
        }
        NacosAnnotationProcessor nacosAnnotationProcessor = this;
        synchronized (nacosAnnotationProcessor) {
            if (!this.groupKeyCache.containsKey(GroupKey.getKey((String)dataId, (String)group))) {
                String content = this.getNacosConfigManager().getConfigService().getConfig(dataId, group, 5000L);
                this.groupKeyCache.put(GroupKey.getKey((String)dataId, (String)group), new AtomicReference<String>(content));
                if (!refreshed) {
                    log.info("[Nacos Config] refreshed is set to false, not listening config for annotation: dataId={}, group={}", (Object)dataId, (Object)group);
                    return content;
                }
                log.info("[Nacos Config] Listening config for annotation: dataId={}, group={}", (Object)dataId, (Object)group);
                this.getNacosConfigManager().getConfigService().addListener(dataId, group, (Listener)new AbstractListener(){

                    public void receiveConfigInfo(String s) {
                        NacosAnnotationProcessor.this.groupKeyCache.get(GroupKey.getKey((String)dataId, (String)group)).set(s);
                    }

                    public String toString() {
                        return String.format("sca nacos config annotation cache config listener", new Object[0]);
                    }
                });
            }
            return this.groupKeyCache.get(GroupKey.getKey((String)dataId, (String)group)).get();
        }
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        super.postProcessBeforeInitialization(bean, beanName);
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        super.postProcessAfterInitialization(bean, beanName);
        Class<?> clazz = bean.getClass();
        NacosConfig annotationBean = (NacosConfig)AnnotationUtils.findAnnotation(clazz, NacosConfig.class);
        if (annotationBean != null) {
            this.handleBeanNacosConfigAnnotation(annotationBean.dataId(), annotationBean.group(), annotationBean.key(), annotationBean.refreshed(), beanName, bean, annotationBean.defaultValue());
            return bean;
        }
        for (Field field : this.getBeanFields(clazz)) {
            this.handleFiledAnnotation(bean, beanName, field);
        }
        for (Method method : this.getBeanMethods(clazz)) {
            this.handleMethodAnnotation(bean, beanName, method);
        }
        return bean;
    }

    private List<Field> getBeanFields(Class clazz) {
        ArrayList<Field> res = new ArrayList<Field>();
        ReflectionUtils.doWithFields((Class)clazz, field -> res.add(field));
        return res;
    }

    private List<Method> getBeanMethods(Class clazz) {
        ArrayList<Method> res = new ArrayList<Method>();
        ReflectionUtils.doWithMethods((Class)clazz, method -> res.add(method));
        return res;
    }

    private void handleFiledAnnotation(Object bean, String beanName, Field field) {
        NacosConfig annotation = (NacosConfig)AnnotationUtils.getAnnotation((AnnotatedElement)field, NacosConfig.class);
        if (annotation != null) {
            this.handleFiledNacosConfigAnnotation(annotation, beanName, bean, field);
        }
    }

    private void handleBeanNacosConfigAnnotation(String dataId, String group, final String key, boolean refreshed, String beanName, final Object bean, final String defaultValue) {
        try {
            String config = this.getDestContent(this.getGroupKeyContent(dataId, group, refreshed), key);
            if (!StringUtils.hasText((String)config)) {
                config = defaultValue;
            }
            if (StringUtils.hasText((String)config)) {
                Object targetObject = this.convertContentToTargetType(config, bean.getClass());
                BeanUtils.copyProperties((Object)targetObject, (Object)bean, (String[])NacosAnnotationProcessor.getNullPropertyNames(targetObject));
            }
            String refreshTargetKey = beanName + "#instance#";
            if (!refreshed) {
                log.info("[Nacos Config] refresh is set to false,do not register listener for {} to bean {} ", (Object)refreshTargetKey, bean);
                return;
            }
            TargetRefreshable currentTarget = this.targetListenerMap.get(refreshTargetKey);
            if (currentTarget != null) {
                log.info("[Nacos Config] reset {} listener from  {} to {} ", new Object[]{refreshTargetKey, currentTarget.getTarget(), bean});
                this.targetListenerMap.get(refreshTargetKey).setTarget(bean);
                return;
            }
            log.info("[Nacos Config] register {} listener on {} ", (Object)refreshTargetKey, bean);
            TargetRefreshable listener = null;
            listener = StringUtils.hasText((String)key) ? new NacosPropertiesKeyListener(bean, this.wrapArrayToSet(key)){

                @Override
                public void configChanged(ConfigChangeEvent event) {
                    try {
                        String newConfig;
                        ConfigChangeItem changeItem = event.getChangeItem(key);
                        String string = newConfig = changeItem == null ? null : changeItem.getNewValue();
                        if (!StringUtils.hasText((String)newConfig)) {
                            newConfig = defaultValue;
                        }
                        if (StringUtils.hasText((String)newConfig)) {
                            Object targetObject = NacosAnnotationProcessor.this.convertContentToTargetType(newConfig, this.getTarget().getClass());
                            BeanUtils.copyProperties((Object)targetObject, (Object)this.getTarget(), (String[])NacosAnnotationProcessor.getNullPropertyNames(targetObject));
                        }
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }

                @Override
                public String toString() {
                    return String.format("[spring cloud alibaba nacos config instance key listener , key %s , target %s ] ", key, bean);
                }
            } : new NacosConfigRefreshableListener(bean){

                public void receiveConfigInfo(String configInfo) {
                    if (!StringUtils.hasText((String)configInfo)) {
                        configInfo = defaultValue;
                    }
                    if (StringUtils.hasText((String)configInfo)) {
                        Object targetObject = NacosAnnotationProcessor.this.convertContentToTargetType(configInfo, bean.getClass());
                        BeanUtils.copyProperties((Object)targetObject, (Object)this.getTarget(), (String[])NacosAnnotationProcessor.getNullPropertyNames(targetObject));
                    }
                }

                public String toString() {
                    return String.format("[spring cloud alibaba nacos config instance  listener , key %s , target %s ] ", key, bean);
                }
            };
            this.getNacosConfigManager().getConfigService().addListener(dataId, group, (Listener)listener);
            this.targetListenerMap.put(refreshTargetKey, listener);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void handleMethodNacosConfigKeysChangeListener(NacosConfigKeysListener annotation, String beanName, final Object bean, final Method method) {
        String dataId = annotation.dataId();
        String group = annotation.group();
        try {
            Class<?>[] parameterTypes = method.getParameterTypes();
            if (parameterTypes.length != 1 || !ConfigChangeEvent.class.isAssignableFrom(parameterTypes[0])) {
                throw new RuntimeException("NacosConfigKeysChangeListener must be marked as a single parameter with ConfigChangeEvent");
            }
            String refreshTargetKey = beanName + "#method#" + this.methodSignature(method);
            TargetRefreshable currentTarget = this.targetListenerMap.get(refreshTargetKey);
            if (currentTarget != null) {
                log.info("[Nacos Config] reset {} listener from  {} to {} ", new Object[]{refreshTargetKey, currentTarget.getTarget(), bean});
                this.targetListenerMap.get(refreshTargetKey).setTarget(bean);
                return;
            }
            log.info("[Nacos Config] register {} listener on {} ", (Object)refreshTargetKey, bean);
            NacosPropertiesKeyListener nacosPropertiesKeyListener = new NacosPropertiesKeyListener(bean, this.wrapArrayToSet(annotation.interestedKeys()), this.wrapArrayToSet(annotation.interestedKeyPrefixes())){

                @Override
                public void configChanged(ConfigChangeEvent event) {
                    ReflectionUtils.invokeMethod((Method)method, (Object)this.getTarget(), (Object[])new Object[]{event});
                }

                @Override
                public String toString() {
                    return String.format("sca nacos config listener on bean method %s", bean + "#" + NacosAnnotationProcessor.this.methodSignature(method));
                }
            };
            nacosPropertiesKeyListener.setLastContent(this.getGroupKeyContent(dataId, group, true));
            this.getNacosConfigManager().getConfigService().addListener(dataId, group, (Listener)nacosPropertiesKeyListener);
            this.targetListenerMap.put(refreshTargetKey, nacosPropertiesKeyListener);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    private Set<String> wrapArrayToSet(String ... arrayKeys) {
        return new HashSet<String>(Arrays.asList(arrayKeys));
    }

    private String methodSignature(Method method) {
        StringBuilder signature = new StringBuilder(method.getName() + "(");
        Class<?>[] parameterTypes = method.getParameterTypes();
        for (int i = 0; i < parameterTypes.length; ++i) {
            signature.append(parameterTypes[i].getSimpleName());
            if (i >= parameterTypes.length - 1) continue;
            signature.append(", ");
        }
        signature.append(")");
        return signature.toString();
    }

    private void handleMethodNacosConfigListener(NacosConfigListener annotation, String beanName, final Object bean, final Method method) {
        block9: {
            String dataId = annotation.dataId();
            String group = annotation.group();
            final String key = annotation.key();
            try {
                final Type[] parameterTypes = method.getGenericParameterTypes();
                if (parameterTypes.length != 1) {
                    throw new RuntimeException("@NacosConfigListener  must be over a method with  a single parameter");
                }
                String configInfo = this.getGroupKeyContent(dataId, group, true);
                String refreshTargetKey = beanName + "#method#" + this.methodSignature(method);
                TargetRefreshable currentTarget = this.targetListenerMap.get(refreshTargetKey);
                if (currentTarget != null) {
                    log.info("[Nacos Config] reset {} listener from  {} to {} ", new Object[]{refreshTargetKey, currentTarget.getTarget(), bean});
                    this.targetListenerMap.get(refreshTargetKey).setTarget(bean);
                    return;
                }
                log.info("[Nacos Config] register {} listener on {} ", (Object)refreshTargetKey, bean);
                TargetRefreshable listener = null;
                if (StringUtils.hasText((String)key)) {
                    listener = new NacosPropertiesKeyListener(bean, this.wrapArrayToSet(key)){

                        @Override
                        public void configChanged(ConfigChangeEvent event) {
                            try {
                                String newConfig;
                                ConfigChangeItem changeItem = event.getChangeItem(key);
                                String string = newConfig = changeItem == null ? null : changeItem.getNewValue();
                                if (StringUtils.hasText((String)newConfig)) {
                                    if (NacosAnnotationProcessor.this.invokePrimitiveMethod(method, this.getTarget(), newConfig)) {
                                        return;
                                    }
                                    Object targetObject = NacosAnnotationProcessor.this.convertContentToTargetType(newConfig, parameterTypes[0]);
                                    ReflectionUtils.invokeMethod((Method)method, (Object)this.getTarget(), (Object[])new Object[]{targetObject});
                                }
                            }
                            catch (Exception e) {
                                throw new RuntimeException(e);
                            }
                        }

                        @Override
                        public String toString() {
                            return String.format("[spring cloud alibaba nacos config key listener , key %s , target %s ] ", key, bean + "#" + NacosAnnotationProcessor.this.methodSignature(method));
                        }
                    };
                    ((AbstractConfigChangeListener)listener).fillContext(dataId, group);
                    if (!annotation.initNotify()) {
                        ((AbstractConfigChangeListener)listener).setLastContent(configInfo);
                    }
                } else {
                    listener = new NacosConfigRefreshableListener(bean){

                        public void receiveConfigInfo(String configInfo) {
                            if (StringUtils.hasText((String)configInfo)) {
                                try {
                                    if (NacosAnnotationProcessor.this.invokePrimitiveMethod(method, this.getTarget(), configInfo)) {
                                        return;
                                    }
                                    Object targetObject = NacosAnnotationProcessor.this.convertContentToTargetType(configInfo, parameterTypes[0]);
                                    ReflectionUtils.invokeMethod((Method)method, (Object)this.getTarget(), (Object[])new Object[]{targetObject});
                                }
                                catch (Exception e) {
                                    throw new RuntimeException(e);
                                }
                            }
                        }

                        public String toString() {
                            return String.format("[spring cloud alibaba nacos config  listener ,  target %s ] ", bean + "#" + NacosAnnotationProcessor.this.methodSignature(method));
                        }
                    };
                }
                this.getNacosConfigManager().getConfigService().addListener(dataId, group, (Listener)listener);
                this.targetListenerMap.put(refreshTargetKey, listener);
                if (!annotation.initNotify() || !StringUtils.hasText((String)configInfo)) break block9;
                try {
                    log.info("[Nacos Config] init notify listener of {}  on {} start...", (Object)refreshTargetKey, bean);
                    listener.receiveConfigInfo(configInfo);
                    log.info("[Nacos Config] init notify listener of {}  on {} finished ", (Object)refreshTargetKey, bean);
                }
                catch (Throwable throwable) {
                    log.warn("[Nacos Config] init notify listener error", throwable);
                    throw throwable;
                }
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }
    }

    Object convertContentToTargetType(String rawContent, Type type) {
        if (String.class.getCanonicalName().equals(type.getTypeName())) {
            return rawContent;
        }
        if (Properties.class.getCanonicalName().equals(type.getTypeName())) {
            Properties properties = new Properties();
            try {
                if (StringUtils.hasText((String)rawContent)) {
                    properties = PropertiesUtils.convertToProperties(rawContent);
                }
            }
            catch (Throwable throwable) {
                throw new RuntimeException(throwable);
            }
            return properties;
        }
        return ObjectUtils.convertToObject(rawContent, type);
    }

    private void handleFiledNacosConfigAnnotation(NacosConfig annotation, String beanName, Object bean, Field field) {
        String dataId = annotation.dataId();
        String group = annotation.group();
        String key = annotation.key();
        try {
            ReflectionUtils.makeAccessible((Field)field);
            this.handleFiledNacosConfigAnnotationInner(dataId, group, key, annotation.refreshed(), beanName, bean, field, annotation.defaultValue());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void handleFiledNacosConfigAnnotationInner(String dataId, String group, final String key, boolean refreshed, String beanName, final Object bean, final Field field, final String defaultValue) {
        try {
            String config = this.getDestContent(this.getGroupKeyContent(dataId, group, refreshed), key);
            if (!StringUtils.hasText((String)config)) {
                config = defaultValue;
            }
            if (this.handPrimitiveFiled(field, dataId, group, config, key, defaultValue, refreshed, beanName, bean)) {
                return;
            }
            if (StringUtils.hasText((String)config)) {
                Object targetObject = this.convertContentToTargetType(config, field.getGenericType());
                ReflectionUtils.setField((Field)field, (Object)bean, (Object)targetObject);
            }
            String refreshTargetKey = beanName + "#filed#" + field.getName();
            if (!refreshed) {
                log.info("[Nacos Config] refresh is set to false,do not register listener for {} to bean {} ", (Object)refreshTargetKey, bean);
                return;
            }
            TargetRefreshable currentTarget = this.targetListenerMap.get(refreshTargetKey);
            if (currentTarget != null) {
                log.info("[Nacos Config] reset {} listener from  {} to {} ", new Object[]{refreshTargetKey, currentTarget.getTarget(), bean});
                this.targetListenerMap.get(refreshTargetKey).setTarget(bean);
                return;
            }
            log.info("[Nacos Config] register {} listener on {} ", (Object)refreshTargetKey, bean);
            TargetRefreshable listener = null;
            listener = StringUtils.hasText((String)key) ? new NacosPropertiesKeyListener(bean, this.wrapArrayToSet(key)){

                @Override
                public void configChanged(ConfigChangeEvent event) {
                    try {
                        String newConfig;
                        ConfigChangeItem changeItem = event.getChangeItem(key);
                        String string = newConfig = changeItem == null ? null : changeItem.getNewValue();
                        if (!StringUtils.hasText((String)newConfig)) {
                            newConfig = defaultValue;
                        }
                        if (StringUtils.hasText((String)newConfig)) {
                            Object targetObject = NacosAnnotationProcessor.this.convertContentToTargetType(newConfig, field.getGenericType());
                            ReflectionUtils.setField((Field)field, (Object)this.getTarget(), (Object)targetObject);
                        }
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }

                @Override
                public String toString() {
                    return String.format("[spring cloud alibaba nacos config key listener , key %s , target %s ] ", key, bean + "#" + field.getName());
                }
            } : new NacosConfigRefreshableListener(bean){

                public void receiveConfigInfo(String configInfo) {
                    if (!StringUtils.hasText((String)configInfo)) {
                        configInfo = defaultValue;
                    }
                    if (StringUtils.hasText((String)configInfo)) {
                        Object targetObject = NacosAnnotationProcessor.this.convertContentToTargetType(configInfo, field.getGenericType());
                        ReflectionUtils.setField((Field)field, (Object)this.getTarget(), (Object)targetObject);
                    }
                }

                public String toString() {
                    return String.format("[spring cloud alibaba nacos config key listener , key %s , target %s ] ", key, bean + "#" + field.getName());
                }
            };
            this.getNacosConfigManager().getConfigService().addListener(dataId, group, (Listener)listener);
            this.targetListenerMap.put(refreshTargetKey, listener);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private boolean handPrimitiveFiled(final Field field, String dataId, String group, String config, final String key, final String defaultValue, boolean refreshed, String beanName, final Object bean) throws Exception {
        if (field.getType().isPrimitive()) {
            if (StringUtils.hasText((String)config)) {
                try {
                    this.setPrimitiveFiled(field, bean, config);
                }
                catch (Throwable throwable) {
                    throw new RuntimeException(throwable);
                }
            }
            String refreshTargetKey = beanName + "#filed#" + field.getName();
            if (!refreshed) {
                log.info("[Nacos Config] refresh is set to false,do not register listener for {} to bean {} ", (Object)refreshTargetKey, bean);
                return true;
            }
            TargetRefreshable currentTarget = this.targetListenerMap.get(refreshTargetKey);
            if (currentTarget != null) {
                log.info("[Nacos Config] reset {} listener from  {} to {} ", new Object[]{refreshTargetKey, currentTarget.getTarget(), bean});
                this.targetListenerMap.get(refreshTargetKey).setTarget(bean);
                return true;
            }
            log.info("[Nacos Config] register {} listener on {} ", (Object)refreshTargetKey, bean);
            TargetRefreshable listener = null;
            listener = StringUtils.hasText((String)key) ? new NacosPropertiesKeyListener(bean, this.wrapArrayToSet(key)){

                @Override
                public void configChanged(ConfigChangeEvent event) {
                    try {
                        String newConfig;
                        ConfigChangeItem changeItem = event.getChangeItem(key);
                        String string = newConfig = changeItem == null ? null : changeItem.getNewValue();
                        if (!StringUtils.hasText((String)newConfig)) {
                            newConfig = defaultValue;
                        }
                        if (StringUtils.hasText((String)newConfig)) {
                            NacosAnnotationProcessor.this.setPrimitiveFiled(field, this.getTarget(), newConfig);
                        }
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }

                @Override
                public String toString() {
                    return String.format("[spring cloud alibaba nacos config key listener , key %s , target %s ] ", key, bean + "#" + field.getName());
                }
            } : new NacosConfigRefreshableListener(bean){

                public void receiveConfigInfo(String configInfo) {
                    if (!StringUtils.hasText((String)configInfo)) {
                        configInfo = defaultValue;
                    }
                    if (StringUtils.hasText((String)configInfo)) {
                        try {
                            NacosAnnotationProcessor.this.setPrimitiveFiled(field, this.getTarget(), configInfo);
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    }
                }

                public String toString() {
                    return String.format("[spring cloud alibaba nacos config key listener , key %s , target %s ] ", key, bean + "#" + field.getName());
                }
            };
            this.getNacosConfigManager().getConfigService().addListener(dataId, group, (Listener)listener);
            this.targetListenerMap.put(refreshTargetKey, listener);
            return true;
        }
        return false;
    }

    private boolean setPrimitiveFiled(Field filed, Object bean, String value) throws Exception {
        if (filed.getType() == Integer.TYPE) {
            filed.setInt(bean, Integer.parseInt(value));
        } else if (filed.getType() == Integer.class) {
            ReflectionUtils.setField((Field)filed, (Object)bean, (Object)Integer.valueOf(value));
        } else if (filed.getType() == Long.TYPE) {
            filed.setLong(bean, Long.parseLong(value));
        } else if (filed.getType() == Long.class) {
            ReflectionUtils.setField((Field)filed, (Object)bean, (Object)Long.valueOf(value));
        } else if (filed.getType() == Boolean.TYPE) {
            filed.setBoolean(bean, Boolean.parseBoolean(value));
        } else if (filed.getType() == Boolean.class) {
            ReflectionUtils.setField((Field)filed, (Object)bean, (Object)Boolean.valueOf(value));
        } else if (filed.getType() == Double.TYPE) {
            filed.setDouble(bean, Double.parseDouble(value));
        } else if (filed.getType() == Double.class) {
            ReflectionUtils.setField((Field)filed, (Object)bean, (Object)Double.valueOf(value));
        } else if (filed.getType() == Float.TYPE) {
            filed.setFloat(bean, Float.parseFloat(value));
        } else if (filed.getType() == Float.class) {
            ReflectionUtils.setField((Field)filed, (Object)bean, (Object)Float.valueOf(value));
        } else {
            return false;
        }
        return true;
    }

    private boolean invokePrimitiveMethod(Method method, Object bean, String value) throws Exception {
        Class<?> parameterType = method.getParameterTypes()[0];
        if (parameterType == Integer.TYPE) {
            ReflectionUtils.invokeMethod((Method)method, (Object)bean, (Object[])new Object[]{Integer.parseInt(value)});
        } else if (parameterType == Integer.class) {
            ReflectionUtils.invokeMethod((Method)method, (Object)bean, (Object[])new Object[]{Integer.valueOf(value)});
        } else if (parameterType == Long.TYPE) {
            ReflectionUtils.invokeMethod((Method)method, (Object)bean, (Object[])new Object[]{Long.parseLong(value)});
        } else if (parameterType == Long.class) {
            ReflectionUtils.invokeMethod((Method)method, (Object)bean, (Object[])new Object[]{Long.valueOf(value)});
        } else if (parameterType == Boolean.TYPE) {
            ReflectionUtils.invokeMethod((Method)method, (Object)bean, (Object[])new Object[]{Boolean.parseBoolean(value)});
        } else if (parameterType == Boolean.class) {
            ReflectionUtils.invokeMethod((Method)method, (Object)bean, (Object[])new Object[]{Boolean.valueOf(value)});
        } else if (parameterType == Double.TYPE) {
            ReflectionUtils.invokeMethod((Method)method, (Object)bean, (Object[])new Object[]{Double.parseDouble(value)});
        } else if (parameterType == Double.class) {
            ReflectionUtils.invokeMethod((Method)method, (Object)bean, (Object[])new Object[]{Double.valueOf(value)});
        } else if (parameterType == Float.TYPE) {
            ReflectionUtils.invokeMethod((Method)method, (Object)bean, (Object[])new Object[]{Float.valueOf(Float.parseFloat(value))});
        } else if (parameterType == Float.class) {
            ReflectionUtils.invokeMethod((Method)method, (Object)bean, (Object[])new Object[]{Float.valueOf(value)});
        } else {
            return false;
        }
        return true;
    }

    private String getDestContent(String content, String key) throws Exception {
        if (StringUtils.hasText((String)key)) {
            Properties properties = PropertiesUtils.convertToProperties(content);
            return properties.getProperty(key);
        }
        return content;
    }

    private void handleMethodAnnotation(Object bean, String beanName, Method method) {
        MergedAnnotations annotations;
        MethodMetadata factoryMethodMetadata;
        NacosConfigKeysListener keysAnnotation = (NacosConfigKeysListener)AnnotationUtils.getAnnotation((Method)method, NacosConfigKeysListener.class);
        if (keysAnnotation != null) {
            ReflectionUtils.makeAccessible((Method)method);
            this.handleMethodNacosConfigKeysChangeListener(keysAnnotation, beanName, bean, method);
            return;
        }
        NacosConfigListener configAnnotation = (NacosConfigListener)AnnotationUtils.getAnnotation((Method)method, NacosConfigListener.class);
        if (configAnnotation != null) {
            ReflectionUtils.makeAccessible((Method)method);
            this.handleMethodNacosConfigListener(configAnnotation, beanName, bean, method);
            return;
        }
        if (!this.applicationContext.containsBeanDefinition(beanName)) {
            return;
        }
        BeanDefinition beanDefinition = ((GenericApplicationContext)this.applicationContext).getBeanDefinition(beanName);
        if (beanDefinition instanceof AnnotatedBeanDefinition && (factoryMethodMetadata = ((AnnotatedBeanDefinition)beanDefinition).getFactoryMethodMetadata()) != null && (annotations = factoryMethodMetadata.getAnnotations()) != null && annotations.isPresent(NacosConfig.class)) {
            MergedAnnotation nacosConfigMergedAnnotation = annotations.get(NacosConfig.class);
            Map stringObjectMap = nacosConfigMergedAnnotation.asMap(new MergedAnnotation.Adapt[0]);
            String dataId = (String)stringObjectMap.get("dataId");
            String group = (String)stringObjectMap.get("group");
            String key = (String)stringObjectMap.get("key");
            String defaultValue = (String)stringObjectMap.get("defaultValue");
            this.handleBeanNacosConfigAnnotation(dataId, group, key, true, beanName, bean, defaultValue);
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    private NacosConfigManager getNacosConfigManager() {
        if (this.nacosConfigManager == null) {
            this.nacosConfigManager = (NacosConfigManager)this.applicationContext.getBean(NacosConfigManager.class);
        }
        return this.nacosConfigManager;
    }

    private static String[] getNullPropertyNames(Object source) {
        BeanWrapperImpl src = new BeanWrapperImpl(source);
        PropertyDescriptor[] pds = src.getPropertyDescriptors();
        HashSet<String> nullPropertyNames = new HashSet<String>();
        for (PropertyDescriptor pd : pds) {
            String propertyName = pd.getName();
            try {
                Object propertyValue = src.getPropertyValue(propertyName);
                if (propertyValue != null) continue;
                nullPropertyNames.add(propertyName);
            }
            catch (NotReadablePropertyException e) {
                nullPropertyNames.add(propertyName);
            }
        }
        return nullPropertyNames.toArray(new String[0]);
    }
}

