/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.nacos.refresh;

import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NacosSnapshotConfigManager {
    private static final Logger log = LoggerFactory.getLogger(NacosSnapshotConfigManager.class);
    private static final Map<String, String> CONFIG_INFO_SNAPSHOT_MAP = new ConcurrentHashMap<String, String>(8);
    private static final int MAX_SNAPSHOT_COUNT = 100;

    private NacosSnapshotConfigManager() {
    }

    private static String formatConfigSnapshotKey(String dataId, String group) {
        return dataId + "@" + group;
    }

    public static String getAndRemoveConfigSnapshot(String dataId, String group) {
        String configInfo = CONFIG_INFO_SNAPSHOT_MAP.get(NacosSnapshotConfigManager.formatConfigSnapshotKey(dataId, group));
        NacosSnapshotConfigManager.removeConfigSnapshot(dataId, group);
        return configInfo;
    }

    public static void putConfigSnapshot(String dataId, String group, String configInfo) {
        try {
            if (CONFIG_INFO_SNAPSHOT_MAP.size() > 100) {
                Iterator<Map.Entry<String, String>> iterator = CONFIG_INFO_SNAPSHOT_MAP.entrySet().iterator();
                iterator.next();
                iterator.remove();
            }
            String snapshotKey = NacosSnapshotConfigManager.formatConfigSnapshotKey(dataId, group);
            if (configInfo == null) {
                CONFIG_INFO_SNAPSHOT_MAP.remove(snapshotKey);
            } else {
                CONFIG_INFO_SNAPSHOT_MAP.put(snapshotKey, configInfo);
            }
        }
        catch (Exception e) {
            log.warn("remove nacos config snapshot error", (Throwable)e);
        }
    }

    public static void removeConfigSnapshot(String dataId, String group) {
        CONFIG_INFO_SNAPSHOT_MAP.remove(NacosSnapshotConfigManager.formatConfigSnapshotKey(dataId, group));
    }
}

