/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.nacos.proxy.druid;

import com.alibaba.cloud.nacos.NacosConfigManager;
import com.alibaba.cloud.nacos.utils.StringUtils;
import com.alibaba.druid.filter.FilterAdapter;
import com.alibaba.druid.pool.DruidDataSource;
import com.alibaba.druid.proxy.jdbc.DataSourceProxy;
import com.alibaba.nacos.api.config.ConfigService;
import com.alibaba.nacos.api.config.listener.AbstractListener;
import com.alibaba.nacos.api.config.listener.Listener;
import com.alibaba.nacos.api.exception.NacosException;
import java.io.StringReader;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class NacosDruidConfigFilter
extends FilterAdapter {
    private static final String groupMatched = "nacos-datasource";
    private final Set<String> idempotentControl = new HashSet<String>();
    private final String proxyDataId;
    private static final String druidPrefix = "spring.datasource.druid.";
    private static final String datasourcePrefix = "spring.datasource.";

    public NacosDruidConfigFilter(String proxyDataId) {
        this.proxyDataId = proxyDataId;
    }

    public void init(final DataSourceProxy dataSourceProxy) {
        String name;
        if (!(dataSourceProxy instanceof DruidDataSource)) {
            return;
        }
        String string = name = StringUtils.isNotBlank(dataSourceProxy.getName()) ? dataSourceProxy.getName() : String.valueOf(dataSourceProxy.hashCode());
        if (this.idempotentControl.contains(name)) {
            return;
        }
        DruidDataSource druidDataSource = (DruidDataSource)dataSourceProxy;
        ConfigService configService = NacosConfigManager.getInstance().getConfigService();
        try {
            String druidProperties = configService.getConfig(this.proxyDataId, groupMatched, 3000L);
            Properties propertiesNew = NacosDruidConfigFilter.convert(druidProperties);
            druidDataSource.configFromProperties(propertiesNew);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        try {
            configService.addListener(this.proxyDataId, groupMatched, (Listener)new AbstractListener(){

                public void receiveConfigInfo(String configInfo) {
                    try {
                        Properties propertiesNew = NacosDruidConfigFilter.convert(configInfo);
                        ((DruidDataSource)dataSourceProxy).configFromProperties(propertiesNew);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }
        catch (NacosException e) {
            throw new RuntimeException(e);
        }
        this.idempotentControl.add(name);
    }

    private static Properties convert(String config) throws Exception {
        Properties properties = new Properties();
        properties.load(new StringReader(config));
        Properties propertiesNew = new Properties();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String key = entry.getKey().toString();
            String value = entry.getValue().toString();
            if (key.startsWith(druidPrefix)) {
                propertiesNew.put(key.replace(druidPrefix, "druid."), value);
                continue;
            }
            if (!key.startsWith(datasourcePrefix)) continue;
            propertiesNew.put(key.replace(datasourcePrefix, "druid."), value);
        }
        return propertiesNew;
    }
}

