/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.spring.boot.redis.actuate.autoconfigure;

import com.alibaba.cloud.spring.boot.context.autoconfigure.AliCloudContextAutoConfiguration;
import com.alibaba.cloud.spring.boot.context.condition.ConditionalOnAliCloudEndpoint;
import com.alibaba.cloud.spring.boot.context.condition.ConditionalOnRequiredProperty;
import com.alibaba.cloud.spring.boot.context.env.AliCloudProperties;
import com.alibaba.cloud.spring.boot.redis.actuate.endpoint.RedisDescribeAccountsEndpoint;
import com.alibaba.cloud.spring.boot.redis.actuate.endpoint.RedisDescribeAvailableResourceEndpoint;
import com.alibaba.cloud.spring.boot.redis.actuate.endpoint.RedisDescribeInstancesEndpoint;
import com.alibaba.cloud.spring.boot.redis.autocofigure.RedisAutoConfiguration;
import com.alibaba.cloud.spring.boot.redis.env.RedisProperties;
import org.springframework.boot.actuate.autoconfigure.endpoint.condition.ConditionalOnAvailableEndpoint;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;

@ConditionalOnClass(name={"org.springframework.boot.actuate.endpoint.annotation.Endpoint"})
@ConditionalOnProperty(name={"alibaba.cloud.redis.enabled"}, havingValue="true", matchIfMissing=true)
@ConditionalOnAliCloudEndpoint
@PropertySource(name="Alibaba Cloud Redis Endpoints Default Properties", value={"classpath:/META-INF/redis/default/actuator-endpoints.properties"})
@Configuration(proxyBeanMethods=false)
@AutoConfigureAfter(value={AliCloudContextAutoConfiguration.class, RedisAutoConfiguration.class})
public class RedisEndpointAutoConfiguration {
    private final AliCloudProperties aliCloudProperties;
    private final RedisProperties redisProperties;

    public RedisEndpointAutoConfiguration(AliCloudProperties aliCloudProperties, RedisProperties redisProperties) {
        this.aliCloudProperties = aliCloudProperties;
        this.redisProperties = redisProperties;
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnAvailableEndpoint
    public RedisDescribeAvailableResourceEndpoint redisDescribeAvailableResourceEndpoint() {
        return new RedisDescribeAvailableResourceEndpoint(this.aliCloudProperties, this.redisProperties);
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnAvailableEndpoint
    @ConditionalOnRequiredProperty(value="alibaba.cloud.redis.instance-id")
    public RedisDescribeAccountsEndpoint redisDescribeAccountsEndpoint() {
        return new RedisDescribeAccountsEndpoint(this.aliCloudProperties, this.redisProperties);
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnAvailableEndpoint
    public RedisDescribeInstancesEndpoint redisDescribeInstancesEndpoint() {
        return new RedisDescribeInstancesEndpoint(this.aliCloudProperties, this.redisProperties);
    }
}

