/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.spring.boot.context.condition;

import com.alibaba.cloud.spring.boot.context.condition.ConditionalOnRequiredProperty;
import java.util.Map;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.type.AnnotatedTypeMetadata;

class OnRequiredPropertyCondition
extends SpringBootCondition {
    private static final String annotationName = ConditionalOnRequiredProperty.class.getName();

    OnRequiredPropertyCondition() {
    }

    public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
        Map annotationAttributes = metadata.getAnnotationAttributes(annotationName);
        return OnRequiredPropertyCondition.doGetMatchOutcome(context, annotationAttributes);
    }

    protected static ConditionOutcome doGetMatchOutcome(ConditionContext context, Map<String, Object> annotationAttributes) {
        String propertyName = (String)annotationAttributes.get("value");
        return OnRequiredPropertyCondition.doGetMatchOutcome(context, propertyName);
    }

    protected static ConditionOutcome doGetMatchOutcome(ConditionContext context, String propertyName) {
        return context.getEnvironment().containsProperty(propertyName) ? ConditionOutcome.match() : ConditionOutcome.noMatch((String)("The property '" + propertyName + "' is abstract in the PropertySources"));
    }
}

