/*
 * Copyright (C) 2018 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.alibaba.cloud.context.utils;

/**
 * 断言工具类
 *
 * @author xiaolongzuo
 */
public class AssertUtils {

    private AssertUtils() {
    }

    /**
     * 判断对象是否不为null，如果为null，则跑出异常，内容为参数s。
     *
     * @param o 判断是否为null的对象
     * @param s 异常信息
     */
    public static void notNull(Object o, String s) {
        if (o == null) {
            throw new IllegalArgumentException(s);
        }
    }

    /**
     * 判断boolean对象是否为true，如果为false，则跑出异常，内容为参数s。
     *
     * @param b 判断是否为true的对象
     * @param s 异常信息
     */
    public static void isTrue(boolean b, String s) {
        if (!b) {
            throw new IllegalArgumentException(s);
        }
    }
}
