/*
 * Copyright (C) 2018 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.alibaba.cloud.context.acm;

import com.alibaba.cloud.context.AliCloudServerMode;

/**
 * ACM配置简单实现
 *
 * @author xiaolongzuo
 */
public class SimpleAcmConfiguration implements AcmConfiguration {

    private AliCloudServerMode serverMode;

    private String serverList;

    private String serverPort;

    private String group = "DEFAULT_GROUP";

    private int timeout = 3000;

    private String endpoint;

    private String namespace;

    private String ramRoleName;

    private boolean refreshEnabled = true;

    public void setServerMode(AliCloudServerMode serverMode) {
        this.serverMode = serverMode;
    }

    public void setServerList(String serverList) {
        this.serverList = serverList;
    }

    public void setServerPort(String serverPort) {
        this.serverPort = serverPort;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setRamRoleName(String ramRoleName) {
        this.ramRoleName = ramRoleName;
    }

    public void setRefreshEnabled(boolean refreshEnabled) {
        this.refreshEnabled = refreshEnabled;
    }

    @Override
    public AliCloudServerMode getServerMode() {
        return serverMode;
    }

    @Override
    public String getServerList() {
        return serverList;
    }

    @Override
    public String getServerPort() {
        return serverPort;
    }

    @Override
    public String getGroup() {
        return group;
    }

    @Override
    public int getTimeout() {
        return timeout;
    }

    @Override
    public String getEndpoint() {
        return endpoint;
    }

    @Override
    public String getNamespace() {
        return namespace;
    }

    @Override
    public String getRamRoleName() {
        return ramRoleName;
    }

    @Override
    public boolean isRefreshEnabled() {
        return refreshEnabled;
    }
}
