/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.util.regex;

import com.alibaba.citrus.util.Assert;
import com.alibaba.citrus.util.StringUtil;

public abstract class Substitution {
    protected final String replacementPrefixes;

    public Substitution() {
        this("$");
    }

    public Substitution(String replacementPrefixes) {
        this.replacementPrefixes = Assert.assertNotNull(StringUtil.trimToNull(replacementPrefixes), "replacementPrefixes", new Object[0]);
    }

    public final String substitute(String input) {
        if (input == null) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        this.substitute(buf, input);
        return buf.toString();
    }

    public final void substitute(StringBuilder buf, String input) {
        int length = input.length();
        int i = 0;
        while (i < length) {
            char ch = input.charAt(i);
            if (ch == '\\') {
                if (++i < length) {
                    buf.append(input.charAt(i++));
                    continue;
                }
                buf.append(ch);
                continue;
            }
            int index = this.replacementPrefixes.indexOf(ch);
            if (index >= 0) {
                int digit;
                int num = -1;
                int numStartIndex = ++i;
                while (i < length && (digit = input.charAt(i) - 48) >= 0 && digit <= 9) {
                    ++i;
                    if (num == -1) {
                        num = digit;
                        continue;
                    }
                    num = num * 10 + digit;
                }
                if (num == -1) {
                    buf.append(ch);
                    continue;
                }
                String groupValue = this.group(index, num);
                if (groupValue != null) {
                    buf.append(groupValue);
                    continue;
                }
                buf.append(ch);
                buf.append(input, numStartIndex, i);
                continue;
            }
            buf.append(ch);
            ++i;
        }
    }

    protected abstract String group(int var1, int var2);
}

