/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.util.regex;

import com.alibaba.citrus.util.Assert;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class ClassNameWildcardCompiler {
    public static final int MATCH_PREFIX = 4096;
    private static final char ESCAPE_CHAR = '\\';
    private static final char DOT = '.';
    private static final char UNDERSCORE = '_';
    private static final char DOLLAR = '$';
    private static final char STAR = '*';
    private static final char QUESTION = '?';
    private static final String REGEX_MATCH_PREFIX = "^";
    private static final String REGEX_WORD_BOUNDARY = "\\b";
    private static final String REGEX_DOT = "\\.";
    private static final String REGEX_DOT_NO_DUP = "\\.(?!\\.)";
    private static final String REGEX_CLASS_NAME_CHAR = "[\\w\\$]";
    private static final String REGEX_CLASS_NAME_SINGLE_CHAR = "([\\w\\$])";
    private static final String REGEX_CLASS_NAME = "([\\w\\$]*)";
    private static final String REGEX_CLASS_NAME_FULL = "([\\w\\$]+(?:\\.(?!\\.)[\\w\\$]*)*(?=\\.|$)|)\\.?";
    private static final String REGEX_END_OF_NAME = "(?=\\.|$)";
    private static final int LAST_TOKEN_START = 0;
    private static final int LAST_TOKEN_DOT = 1;
    private static final int LAST_TOKEN_CLASS_NAME = 2;
    private static final int LAST_TOKEN_STAR = 3;
    private static final int LAST_TOKEN_DOUBLE_STAR = 4;
    private static final int LAST_TOKEN_QUESTION = 5;

    private ClassNameWildcardCompiler() {
    }

    public static Pattern compileClassName(String pattern) throws PatternSyntaxException {
        return ClassNameWildcardCompiler.compileClassName(pattern, 0);
    }

    public static Pattern compileClassName(String pattern, int options) throws PatternSyntaxException {
        return Pattern.compile(ClassNameWildcardCompiler.classNameToRegex(pattern, options), options);
    }

    public static int getClassNameRelevancy(String pattern) {
        if ((pattern = ClassNameWildcardCompiler.normalizeClassName(pattern)) == null) {
            return 0;
        }
        int relevant = 0;
        block3: for (int i = 0; i < pattern.length(); ++i) {
            switch (pattern.charAt(i)) {
                case '*': 
                case '.': 
                case '?': {
                    continue block3;
                }
                default: {
                    ++relevant;
                }
            }
        }
        return relevant;
    }

    public static String classNameToRegex(String pattern, int options) throws PatternSyntaxException {
        boolean matchPrefix;
        pattern = Assert.assertNotNull(ClassNameWildcardCompiler.normalizeClassName(pattern), "pattern", new Object[0]);
        int lastToken = 0;
        StringBuilder buf = new StringBuilder(pattern.length() * 2);
        boolean bl = matchPrefix = (options & 0x1000) != 0;
        if (matchPrefix) {
            buf.append(REGEX_MATCH_PREFIX);
        }
        block5: for (int i = 0; i < pattern.length(); ++i) {
            char ch = pattern.charAt(i);
            switch (ch) {
                case '.': {
                    if (lastToken == 1 || lastToken == 0) {
                        throw new PatternSyntaxException("Syntax Error", pattern, i);
                    }
                    if (lastToken != 4) {
                        buf.append(REGEX_DOT_NO_DUP);
                    }
                    lastToken = 1;
                    continue block5;
                }
                case '*': {
                    int j = i + 1;
                    if (j < pattern.length() && pattern.charAt(j) == '*') {
                        i = j;
                        if (lastToken != 0 && lastToken != 1) {
                            throw new PatternSyntaxException("Syntax Error", pattern, i);
                        }
                        lastToken = 4;
                        buf.append(REGEX_CLASS_NAME_FULL);
                        continue block5;
                    }
                    if (lastToken == 3 || lastToken == 4) {
                        throw new PatternSyntaxException("Syntax Error", pattern, i);
                    }
                    lastToken = 3;
                    buf.append(REGEX_CLASS_NAME);
                    continue block5;
                }
                case '?': {
                    if (lastToken == 0) {
                        buf.append(REGEX_WORD_BOUNDARY).append(REGEX_CLASS_NAME_SINGLE_CHAR);
                    } else if (i + 1 == pattern.length()) {
                        buf.append(REGEX_CLASS_NAME_SINGLE_CHAR).append(REGEX_END_OF_NAME);
                    } else {
                        buf.append(REGEX_CLASS_NAME_SINGLE_CHAR);
                    }
                    lastToken = 5;
                    continue block5;
                }
                default: {
                    if (lastToken == 4) {
                        throw new PatternSyntaxException("Syntax Error", pattern, i);
                    }
                    if (Character.isLetterOrDigit(ch) || ch == '_') {
                        if (lastToken == 0) {
                            buf.append(REGEX_WORD_BOUNDARY).append(ch);
                        } else if (i + 1 == pattern.length()) {
                            buf.append(ch).append(REGEX_WORD_BOUNDARY);
                        } else {
                            buf.append(ch);
                        }
                    } else if (ch == '$') {
                        buf.append('\\').append('$');
                    } else {
                        throw new PatternSyntaxException("Syntax Error", pattern, i);
                    }
                    lastToken = 2;
                }
            }
        }
        return buf.toString();
    }

    public static String normalizeClassName(String name) {
        if (name == null) {
            return null;
        }
        name = name.trim();
        name = name.replaceAll("[/\\\\\\.]+", ".");
        name = name.replaceAll("^\\.|\\.$", "");
        return name;
    }

    public static String classNameToPathName(String name) {
        if ((name = ClassNameWildcardCompiler.normalizeClassName(name)) == null) {
            return null;
        }
        name = name.replace('.', '/');
        return name;
    }
}

