/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.util.collection;

import com.alibaba.citrus.util.collection.DefaultHashMap;
import com.alibaba.citrus.util.collection.ListMap;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayHashMap<K, V>
extends DefaultHashMap<K, V>
implements ListMap<K, V> {
    private static final long serialVersionUID = 3258411729271927857L;
    protected transient DefaultHashMap.Entry<K, V>[] order;
    private transient List<K> keyList;
    private transient List<V> valueList;
    private transient List<Map.Entry<K, V>> entryList;

    public ArrayHashMap() {
    }

    public ArrayHashMap(int initialCapacity) {
        super(initialCapacity);
    }

    public ArrayHashMap(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    public ArrayHashMap(Map<? extends K, ? extends V> map) {
        super(map);
    }

    @Override
    public boolean containsValue(Object value) {
        for (int i = 0; i < this.size; ++i) {
            Entry entry = (Entry)this.order[i];
            if (!ArrayHashMap.eq(value, entry.getValue())) continue;
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        super.clear();
        Arrays.fill(this.order, null);
    }

    @Override
    public V get(int index) {
        this.checkRange(index);
        return this.order[index].getValue();
    }

    @Override
    public K getKey(int index) {
        this.checkRange(index);
        return this.order[index].getKey();
    }

    @Override
    public Map.Entry<K, V> removeEntry(int index) {
        this.checkRange(index);
        return this.removeEntryForKey(this.order[index].getKey());
    }

    @Override
    public List<K> keyList() {
        return this.keyList != null ? this.keyList : (this.keyList = new KeyList());
    }

    @Override
    public List<V> valueList() {
        return this.valueList != null ? this.valueList : (this.valueList = new ValueList());
    }

    @Override
    public List<Map.Entry<K, V>> entryList() {
        return this.entryList != null ? this.entryList : (this.entryList = new EntryList());
    }

    @Override
    protected void onInit() {
        this.order = new DefaultHashMap.Entry[this.threshold];
    }

    @Override
    protected void addEntry(K key, V value) {
        int hash = ArrayHashMap.hash(key);
        int i = ArrayHashMap.indexFor(hash, this.table.length);
        Entry entry = new Entry(hash, key, value, this.table[i]);
        this.table[i] = entry;
        entry.index = this.size;
        this.order[this.size++] = entry;
    }

    @Override
    protected Iterator<K> newKeyIterator() {
        return new KeyIterator(0);
    }

    @Override
    protected Iterator<V> newValueIterator() {
        return new ValueIterator(0);
    }

    @Override
    protected Iterator<Map.Entry<K, V>> newEntryIterator() {
        return new EntryIterator(0);
    }

    @Override
    protected void resize(int newCapacity) {
        super.resize(newCapacity);
        if (this.threshold > this.order.length) {
            DefaultHashMap.Entry[] newOrder = new DefaultHashMap.Entry[this.threshold];
            System.arraycopy(this.order, 0, newOrder, 0, this.order.length);
            this.order = newOrder;
        }
    }

    @Override
    protected void transfer(DefaultHashMap.Entry<K, V>[] newTable) {
        int newCapacity = newTable.length;
        for (int i = 0; i < this.size; ++i) {
            Entry entry = (Entry)this.order[i];
            int index = ArrayHashMap.indexFor(entry.hash, newCapacity);
            entry.next = newTable[index];
            newTable[index] = entry;
        }
    }

    private void checkRange(int index) {
        if (index >= this.size || index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ValueList
    extends ArrayHashList<V> {
        private ValueList() {
        }

        @Override
        public boolean contains(Object o) {
            return ArrayHashMap.this.containsValue(o);
        }

        @Override
        public Iterator<V> iterator() {
            return ArrayHashMap.this.newValueIterator();
        }

        @Override
        public boolean remove(Object o) {
            int index = this.indexOf(o);
            if (index != -1) {
                ArrayHashMap.this.removeEntry(index);
                return true;
            }
            return false;
        }

        @Override
        public V remove(int index) {
            ArrayHashMap.this.checkRange(index);
            return ArrayHashMap.this.removeEntryForKey(ArrayHashMap.this.order[index].getKey()).getValue();
        }

        @Override
        public V get(int index) {
            ArrayHashMap.this.checkRange(index);
            return ArrayHashMap.this.order[index].getValue();
        }

        @Override
        public int indexOf(Object o) {
            for (int i = 0; i < ArrayHashMap.this.size; ++i) {
                if (!DefaultHashMap.eq(o, ArrayHashMap.this.order[i].getValue())) continue;
                return i;
            }
            return -1;
        }

        @Override
        public ListIterator<V> listIterator(int index) {
            return new ValueIterator(index);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KeyList
    extends ArrayHashList<K> {
        private KeyList() {
        }

        @Override
        public boolean contains(Object o) {
            return ArrayHashMap.this.containsKey(o);
        }

        @Override
        public Iterator<K> iterator() {
            return ArrayHashMap.this.newKeyIterator();
        }

        @Override
        public boolean remove(Object o) {
            Entry entry = (Entry)ArrayHashMap.this.getEntry(o);
            if (entry == null) {
                return false;
            }
            ArrayHashMap.this.removeEntry(entry);
            return true;
        }

        @Override
        public K remove(int index) {
            ArrayHashMap.this.checkRange(index);
            return ArrayHashMap.this.removeEntryForKey(ArrayHashMap.this.order[index].getKey()).getKey();
        }

        @Override
        public K get(int index) {
            ArrayHashMap.this.checkRange(index);
            return ArrayHashMap.this.order[index].getKey();
        }

        @Override
        public int indexOf(Object o) {
            Entry entry = (Entry)ArrayHashMap.this.getEntry(o);
            if (entry != null) {
                return entry.index;
            }
            return -1;
        }

        @Override
        public ListIterator<K> listIterator(int index) {
            return new KeyIterator(index);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EntryList
    extends ArrayHashList<Map.Entry<K, V>> {
        private EntryList() {
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)o;
            Entry candidate = (Entry)ArrayHashMap.this.getEntry(entry.getKey());
            return DefaultHashMap.eq(candidate, entry);
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return ArrayHashMap.this.newEntryIterator();
        }

        @Override
        public boolean remove(Object o) {
            return ArrayHashMap.this.removeEntry(o) != null;
        }

        @Override
        public Map.Entry<K, V> remove(int index) {
            ArrayHashMap.this.checkRange(index);
            return ArrayHashMap.this.removeEntryForKey(ArrayHashMap.this.order[index].getKey());
        }

        @Override
        public Map.Entry<K, V> get(int index) {
            ArrayHashMap.this.checkRange(index);
            return ArrayHashMap.this.order[index];
        }

        @Override
        public int indexOf(Object o) {
            Entry entry;
            if (o != null && o instanceof Map.Entry && (entry = (Entry)ArrayHashMap.this.getEntry(((Map.Entry)o).getKey())) != null && entry.equals(o)) {
                return entry.index;
            }
            return -1;
        }

        @Override
        public ListIterator<Map.Entry<K, V>> listIterator(int index) {
            return new EntryIterator(index);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class ArrayHashList<E>
    extends AbstractList<E> {
        private ArrayHashList() {
        }

        @Override
        public int size() {
            return ArrayHashMap.this.size;
        }

        @Override
        public boolean isEmpty() {
            return ArrayHashMap.this.size == 0;
        }

        @Override
        public void clear() {
            ArrayHashMap.this.clear();
        }

        @Override
        public int lastIndexOf(Object o) {
            return this.indexOf(o);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EntryIterator
    extends ArrayHashIterator<Map.Entry<K, V>> {
        protected EntryIterator(int index) {
            super(index);
        }

        @Override
        public Map.Entry<K, V> next() {
            return this.nextEntry();
        }

        @Override
        public Map.Entry<K, V> previous() {
            return this.previousEntry();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ValueIterator
    extends ArrayHashIterator<V> {
        protected ValueIterator(int index) {
            super(index);
        }

        @Override
        public void set(V o) {
            this.setValue(o);
        }

        @Override
        public V next() {
            return this.nextEntry().getValue();
        }

        @Override
        public V previous() {
            return this.previousEntry().getValue();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KeyIterator
    extends ArrayHashIterator<K> {
        protected KeyIterator(int index) {
            super(index);
        }

        @Override
        public K next() {
            return this.nextEntry().getKey();
        }

        @Override
        public K previous() {
            return this.previousEntry().getKey();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class ArrayHashIterator<E>
    implements ListIterator<E> {
        private Entry lastReturned;
        private int cursor;
        private int expectedModCount;

        protected ArrayHashIterator(int index) {
            if (index < 0 || index > ArrayHashMap.this.size()) {
                throw new IndexOutOfBoundsException("Index: " + index);
            }
            this.cursor = index;
            this.expectedModCount = ArrayHashMap.this.modCount;
        }

        @Override
        public void add(E o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(E o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasNext() {
            return this.cursor < ArrayHashMap.this.size;
        }

        @Override
        public boolean hasPrevious() {
            return this.cursor > 0;
        }

        @Override
        public int nextIndex() {
            return this.cursor;
        }

        @Override
        public int previousIndex() {
            return this.cursor - 1;
        }

        @Override
        public void remove() {
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            this.checkForComodification();
            ArrayHashMap.this.removeEntryForKey(this.lastReturned.getKey());
            if (this.lastReturned.index < this.cursor) {
                --this.cursor;
            }
            this.lastReturned = null;
            this.expectedModCount = ArrayHashMap.this.modCount;
        }

        protected Entry nextEntry() {
            this.checkForComodification();
            if (this.cursor >= ArrayHashMap.this.size) {
                throw new NoSuchElementException();
            }
            this.lastReturned = (Entry)ArrayHashMap.this.order[this.cursor++];
            return this.lastReturned;
        }

        protected Entry previousEntry() {
            this.checkForComodification();
            if (this.cursor <= 0) {
                throw new NoSuchElementException();
            }
            this.lastReturned = (Entry)ArrayHashMap.this.order[--this.cursor];
            return this.lastReturned;
        }

        protected void setValue(V o) {
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            this.checkForComodification();
            this.lastReturned.setValue(o);
        }

        private void checkForComodification() {
            if (ArrayHashMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class Entry
    extends DefaultHashMap.Entry<K, V> {
        protected int index;

        protected Entry(int h, K k, V v, DefaultHashMap.Entry<K, V> n) {
            super(h, k, v, n);
        }

        @Override
        protected void onRemove() {
            int numMoved = ArrayHashMap.this.size - this.index;
            if (numMoved > 0) {
                System.arraycopy(ArrayHashMap.this.order, this.index + 1, ArrayHashMap.this.order, this.index, numMoved);
            }
            ArrayHashMap.this.order[ArrayHashMap.this.size] = null;
            for (int i = this.index; i < ArrayHashMap.this.size; ++i) {
                --((Entry)ArrayHashMap.this.order[i]).index;
            }
        }
    }
}

