/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.turbine.support;

import com.alibaba.citrus.turbine.Context;
import com.alibaba.citrus.util.BasicConstant;
import com.alibaba.citrus.util.CollectionUtil;
import com.alibaba.citrus.util.ToStringBuilder;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractContext
implements Context {
    private final Context parentContext;

    public AbstractContext() {
        this(null);
    }

    public AbstractContext(Context parentContext) {
        this.parentContext = parentContext;
    }

    public Context getParentContext() {
        return this.parentContext;
    }

    @Override
    public final void put(String key, Object value) {
        if (value == null) {
            this.remove(key);
        } else {
            this.internalPut(key, value);
        }
    }

    @Override
    public final Object get(String key) {
        Object value = this.internalGet(key);
        if (value == null && this.parentContext != null) {
            return this.parentContext.get(key);
        }
        return this.decodeValue(value);
    }

    @Override
    public final void remove(String key) {
        if (this.parentContext != null && this.parentContext.containsKey(key)) {
            this.internalPut(key, BasicConstant.NULL_PLACEHOLDER);
        } else {
            this.internalRemove(key);
        }
    }

    @Override
    public final boolean containsKey(String key) {
        boolean containsKey = this.internalContainsKey(key);
        if (!containsKey && this.parentContext != null) {
            return this.parentContext.containsKey(key);
        }
        return containsKey;
    }

    @Override
    public final Set<String> keySet() {
        Set<String> parentKeySet;
        Set<String> internalKeySet = this.internalKeySet();
        Set<String> set = parentKeySet = this.parentContext == null ? null : this.parentContext.keySet();
        if (parentKeySet == null || parentKeySet.isEmpty()) {
            return internalKeySet;
        }
        HashSet<String> newSet = CollectionUtil.createHashSet();
        newSet.addAll(parentKeySet);
        newSet.addAll(internalKeySet);
        return newSet;
    }

    protected abstract Set<String> internalKeySet();

    protected abstract Object internalGet(String var1);

    protected abstract void internalRemove(String var1);

    protected abstract boolean internalContainsKey(String var1);

    protected abstract void internalPut(String var1, Object var2);

    private Object decodeValue(Object value) {
        return value == BasicConstant.NULL_PLACEHOLDER ? null : value;
    }

    public String toString() {
        ToStringBuilder.MapBuilder mb;
        if (this.parentContext == null) {
            mb = this.getMapBuilder();
        } else {
            mb = new ToStringBuilder.MapBuilder();
            mb.append("parentContext", this.parentContext);
            mb.append("thisContext", this.getMapBuilder());
        }
        return new ToStringBuilder().append(this.getClass().getSimpleName()).append(mb).toString();
    }

    private ToStringBuilder.MapBuilder getMapBuilder() {
        ToStringBuilder.MapBuilder mb = new ToStringBuilder.MapBuilder().setSortKeys(true);
        for (String key : this.internalKeySet()) {
            mb.append(key, this.get(key));
        }
        return mb;
    }
}

