/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.turbine.pipeline.valve;

import com.alibaba.citrus.service.moduleloader.ModuleLoaderException;
import com.alibaba.citrus.service.moduleloader.ModuleLoaderService;
import com.alibaba.citrus.service.pipeline.PipelineContext;
import com.alibaba.citrus.service.pipeline.PipelineException;
import com.alibaba.citrus.service.pipeline.support.AbstractValve;
import com.alibaba.citrus.service.pipeline.support.AbstractValveDefinitionParser;
import com.alibaba.citrus.turbine.TurbineRunData;
import com.alibaba.citrus.turbine.util.TurbineUtil;
import com.alibaba.citrus.util.StringUtil;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;

public class PerformActionValve
extends AbstractValve {
    @Autowired
    private HttpServletRequest request;
    @Autowired
    private ModuleLoaderService moduleLoaderService;

    public void invoke(PipelineContext pipelineContext) throws Exception {
        String action;
        TurbineRunData rundata = TurbineUtil.getTurbineRunData(this.request);
        if (!rundata.isRedirected() && !StringUtil.isEmpty(action = rundata.getAction())) {
            String actionKey = "_action_" + action;
            if (rundata.getRequest().getAttribute(actionKey) == null) {
                rundata.getRequest().setAttribute(actionKey, (Object)"executed");
                try {
                    this.moduleLoaderService.getModule("action", action).execute();
                }
                catch (ModuleLoaderException e) {
                    throw new PipelineException("Could not load action module: " + action, e);
                }
                catch (Exception e) {
                    throw new PipelineException("Failed to execute action module", e);
                }
            }
        }
        pipelineContext.invokeNext();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DefinitionParser
    extends AbstractValveDefinitionParser<PerformActionValve> {
    }
}

