/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.turbine.pipeline.condition;

import com.alibaba.citrus.springext.util.SpringExtUtil;
import com.alibaba.citrus.turbine.pipeline.condition.PathCondition;
import com.alibaba.citrus.util.Assert;
import com.alibaba.citrus.webx.WebxComponent;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public class TargetCondition
extends PathCondition {
    @Autowired(required=false)
    private WebxComponent component;
    private boolean withComponentName;

    public void setWithComponentName(boolean withComponentName) {
        this.withComponentName = withComponentName;
    }

    protected String getPath() {
        String target;
        StringBuilder buf = new StringBuilder();
        if (this.withComponentName) {
            Assert.assertNotNull(this.component, "no component", new Object[0]);
            buf.append("/").append(this.component.getName());
        }
        if (!(target = this.getRunData().getTarget()).startsWith("/")) {
            buf.append("/");
        }
        buf.append(target);
        return buf.toString();
    }

    protected void log(String patternString) {
        this.log.debug("Target matched pattern: {}", (Object)patternString);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DefinitionParser
    extends PathCondition.AbstractPathConditionDefinitionParser<TargetCondition> {
        @Override
        protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
            super.doParse(element, parserContext, builder);
            SpringExtUtil.attributesToProperties(element, builder, "withComponentName");
        }
    }
}

