/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.turbine.dataresolver.impl;

import com.alibaba.citrus.service.dataresolver.DataResolver;
import com.alibaba.citrus.service.dataresolver.DataResolverContext;
import com.alibaba.citrus.service.dataresolver.DataResolverFactory;
import com.alibaba.citrus.service.requestcontext.parser.ParameterParser;
import com.alibaba.citrus.service.requestcontext.parser.ParserRequestContext;
import com.alibaba.citrus.springext.support.parser.AbstractSingleBeanDefinitionParser;
import com.alibaba.citrus.springext.util.SpringExtUtil;
import com.alibaba.citrus.turbine.dataresolver.Param;
import com.alibaba.citrus.turbine.dataresolver.Params;
import com.alibaba.citrus.turbine.dataresolver.impl.AbstractDataResolver;
import com.alibaba.citrus.turbine.dataresolver.impl.DataResolverUtil;
import com.alibaba.citrus.util.ArrayUtil;
import com.alibaba.citrus.util.Assert;
import com.alibaba.citrus.util.StringUtil;
import net.sf.cglib.reflect.FastConstructor;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.core.MethodParameter;
import org.w3c.dom.Element;

public class ParameterResolverFactory
implements DataResolverFactory {
    private final ParserRequestContext parserRequestContext;

    public ParameterResolverFactory(ParserRequestContext parserRequestContext) {
        this.parserRequestContext = SpringExtUtil.assertProxy(parserRequestContext);
    }

    public DataResolver getDataResolver(DataResolverContext context) {
        Assert.assertNotNull(this.parserRequestContext, "no ParserRequestContext defined", new Object[0]);
        Param paramAnnotation = context.getAnnotation(Param.class);
        if (paramAnnotation != null) {
            String[] defaultValues = this.getDefaultValues(paramAnnotation, context);
            String paramName = DataResolverUtil.getAnnotationNameOrValue(Param.class, paramAnnotation, context, !ArrayUtil.isEmptyArray(defaultValues));
            return new ParameterResolver(context, defaultValues, paramName);
        }
        Params paramsAnnotation = context.getAnnotation(Params.class);
        if (paramsAnnotation != null) {
            Class<?> beanType = context.getTypeInfo().getRawType();
            FastConstructor fc = DataResolverUtil.getFastConstructor(beanType);
            return new ParametersResolver(context, fc);
        }
        return null;
    }

    private String[] getDefaultValues(Param param, DataResolverContext context) {
        String defaultValue = StringUtil.trimToNull(param.defaultValue());
        if (defaultValue == null) {
            return param.defaultValues();
        }
        Assert.assertTrue(ArrayUtil.isEmptyArray(param.defaultValues()), "use @Param(... defaultValue=\"...\") or @Param(... defaultValues={...}): %s", context);
        return new String[]{defaultValue};
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DefinitionParser
    extends AbstractSingleBeanDefinitionParser<ParameterResolverFactory> {
        protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
            SpringExtUtil.addConstructorArg(builder, false, ParserRequestContext.class);
        }
    }

    private class ParametersResolver
    extends AbstractDataResolver {
        private final FastConstructor fc;

        private ParametersResolver(DataResolverContext context, FastConstructor fc) {
            super("ParametersResolver", context);
            this.fc = Assert.assertNotNull(fc, "fc", new Object[0]);
        }

        public Object resolve() {
            ParameterParser params = ParameterResolverFactory.this.parserRequestContext.getParameters();
            Object object = DataResolverUtil.newInstance(this.fc);
            params.setProperties(object);
            return object;
        }
    }

    private class ParameterResolver
    extends AbstractDataResolver {
        private final String[] defaultValues;
        private final String paramName;

        private ParameterResolver(DataResolverContext context, String[] defaultValues, String paramName) {
            super("ParameterResolver", context);
            this.defaultValues = defaultValues;
            this.paramName = paramName;
        }

        public Object resolve() {
            ParameterParser params = ParameterResolverFactory.this.parserRequestContext.getParameters();
            Class<?> paramType = this.context.getTypeInfo().getRawType();
            MethodParameter methodParameter = this.context.getExtraObject(MethodParameter.class);
            return params.getObjectOfType(this.paramName, paramType, methodParameter, this.defaultValues);
        }
    }
}

