/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.springext.util;

import com.alibaba.citrus.logconfig.LogConfigurator;
import com.alibaba.citrus.springext.ConfigurationPoint;
import com.alibaba.citrus.springext.ContributionType;
import com.alibaba.citrus.springext.Schema;
import com.alibaba.citrus.springext.support.SchemaUtil;
import com.alibaba.citrus.springext.support.SpringExtSchemaSet;
import com.alibaba.citrus.util.ArrayUtil;
import com.alibaba.citrus.util.CollectionUtil;
import com.alibaba.citrus.util.FileUtil;
import com.alibaba.citrus.util.ObjectUtil;
import com.alibaba.citrus.util.StringUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConvertToUnqualifiedStyle {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final File[] sources;
    private final SpringExtSchemaSet schemas;
    private final boolean forceConvert;
    private final boolean backup;
    private int convertedCount;
    private final Pattern backupFilePattern = Pattern.compile("\\.bak$");

    public static void main(String[] args) {
        File[] sources = new File[args.length];
        for (int i = 0; i < args.length; ++i) {
            sources[i] = new File(args[i]).getAbsoluteFile();
        }
        new ConvertToUnqualifiedStyle(sources).convert();
    }

    public ConvertToUnqualifiedStyle(File[] sources) {
        this(sources, false, true);
    }

    public ConvertToUnqualifiedStyle(File[] sources, boolean forceConvert, boolean backup) {
        LogConfigurator.getConfigurator().configureDefault();
        this.sources = sources;
        this.schemas = new SpringExtSchemaSet();
        this.forceConvert = forceConvert;
        this.backup = backup;
    }

    public void convert() {
        if (!ArrayUtil.isEmptyArray(this.sources)) {
            for (File source : this.sources) {
                this.convert(source);
            }
        }
        this.log.info("Converted {} files.", (Object)this.convertedCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void convert(File source) {
        Document doc;
        if (this.backupFilePattern.matcher(source.getName()).find()) {
            return;
        }
        try {
            doc = SchemaUtil.readDocument(new FileInputStream(source), source.getAbsolutePath(), true);
        }
        catch (Exception e) {
            this.log.warn("Failed to read file {}: {}", (Object)this.getRelativePath(source), (Object)e.getMessage());
            return;
        }
        if (!this.isSpringConfigurationFile(doc)) {
            return;
        }
        this.log.info("Converting file: {}", (Object)this.getRelativePath(source));
        boolean modified = new Converter(doc).doConvert();
        if (modified || this.forceConvert) {
            File dir = source.getParentFile();
            String fileName = source.getName();
            int index = fileName.lastIndexOf(".");
            String ext = "";
            if (index >= 0) {
                ext = fileName.substring(index);
                fileName = fileName.substring(0, index);
            }
            File tmpFile = null;
            FileOutputStream fos = null;
            boolean failed = false;
            try {
                tmpFile = File.createTempFile(fileName + "_tmp_", ext, dir);
                fos = new FileOutputStream(tmpFile);
                ConvertToUnqualifiedStyle.writeDocument(doc, fos);
            }
            catch (IOException e) {
                this.log.warn("Failed to write to {}: {}", (Object)this.getRelativePath(tmpFile), (Object)e.getMessage());
                failed = true;
            }
            finally {
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (IOException ignored) {}
                }
            }
            if (failed) {
                tmpFile.delete();
            } else {
                File backupFile = null;
                if (this.backup) {
                    int i = 0;
                    while ((backupFile = new File(dir, fileName + (i == 0 ? "" : "_" + i) + ext + ".bak")).exists()) {
                        ++i;
                    }
                    source.renameTo(backupFile);
                    this.log.info("  ... converted, original content saved as {}", (Object)this.getRelativePath(backupFile));
                } else {
                    source.delete();
                    this.log.info("  ... converted");
                }
                tmpFile.renameTo(source);
                ++this.convertedCount;
            }
        } else {
            this.log.info("  ... skipped");
        }
    }

    private static void writeDocument(Document doc, OutputStream stream) throws IOException {
        String charset = "UTF-8";
        OutputStreamWriter writer = new OutputStreamWriter(stream, charset);
        OutputFormat format = new OutputFormat();
        format.setEncoding(charset);
        XMLWriter xmlWriter = new XMLWriter((Writer)writer, format);
        xmlWriter.write(doc);
        xmlWriter.flush();
    }

    private boolean isSpringConfigurationFile(Document doc) {
        Element root = doc.getRootElement();
        return "http://www.springframework.org/schema/beans".equals(root.getNamespace().getURI()) && "beans".equals(root.getName());
    }

    private boolean isConfigurationPointNamespace(String namespaceURI) {
        return this.schemas.getConfigurationPoints().getConfigurationPointByNamespaceUri(namespaceURI) != null;
    }

    private String getRelativePath(File f) {
        return FileUtil.getRelativePath(new File("").getAbsolutePath(), f.getAbsolutePath());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Converter {
        private final Element root;
        private final LinkedList<String> namespaceURIStack = CollectionUtil.createLinkedList();
        private final Map<String, Namespace> namespaces = CollectionUtil.createTreeMap();
        private boolean modified = false;

        private Converter(Document doc) {
            this.root = doc.getRootElement();
        }

        public boolean doConvert() {
            this.accept(this.root);
            return this.modified;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void accept(Element element) {
            String namespaceURI = StringUtil.trimToNull(element.getNamespace().getURI());
            Iterator i = element.declaredNamespaces().iterator();
            while (i.hasNext()) {
                Namespace declaredNs = (Namespace)i.next();
                if (!ConvertToUnqualifiedStyle.this.isConfigurationPointNamespace(declaredNs.getURI())) continue;
                i.remove();
                if (element != this.root) {
                    this.modified = true;
                }
                if (this.namespaces.containsKey(declaredNs.getURI())) continue;
                Namespace ns = declaredNs;
                String uri = ns.getURI();
                if (StringUtil.isEmpty(ns.getPrefix())) {
                    String prefix = SchemaUtil.getNamespacePrefix(ConvertToUnqualifiedStyle.this.schemas.getConfigurationPoints().getConfigurationPointByNamespaceUri(uri).getPreferredNsPrefix(), uri);
                    ns = Namespace.get((String)prefix, (String)uri);
                    this.modified = true;
                }
                this.namespaces.put(uri, ns);
            }
            if (!ConvertToUnqualifiedStyle.this.isConfigurationPointNamespace(namespaceURI)) {
                this.acceptSubElements(element);
            } else if (!ObjectUtil.isEquals(namespaceURI, this.getContextNamespaceURI()) || this.isContributionElement(namespaceURI, element.getName())) {
                try {
                    this.namespaceURIStack.push(namespaceURI);
                    this.setNamespacePrefix(element, namespaceURI);
                    this.acceptSubElements(element);
                }
                finally {
                    this.namespaceURIStack.pop();
                }
            } else {
                this.setNamespacePrefix(element, null);
                this.acceptSubElements(element);
                this.modified = true;
            }
            if (element == this.root) {
                for (Namespace ns : this.namespaces.values()) {
                    element.add(ns);
                }
                this.formatSchemaLocations();
            }
        }

        private boolean isContributionElement(String uri, String name) {
            ConfigurationPoint cp = ConvertToUnqualifiedStyle.this.schemas.getConfigurationPoints().getConfigurationPointByNamespaceUri(uri);
            if (cp != null) {
                return name.equals(cp.getDefaultElementName()) || cp.getContribution(name, ContributionType.BEAN_DEFINITION_PARSER) != null;
            }
            return false;
        }

        private void formatSchemaLocations() {
            Namespace xsi = this.getXsiNs();
            QName schemaLocationQName = QName.get((String)"schemaLocation", (Namespace)xsi);
            Attribute attr = this.root.attribute(schemaLocationQName);
            String value = attr != null ? attr.getText() : null;
            Map<String, String> schemaLocations = SchemaUtil.parseSchemaLocation(value);
            String locationPrefix = this.getLocationPrefix(schemaLocations);
            for (String namespaceURI : this.namespaces.keySet()) {
                if (schemaLocations.containsKey(namespaceURI)) continue;
                try {
                    Set<Schema> schemaSet = ConvertToUnqualifiedStyle.this.schemas.getNamespaceMappings().get(namespaceURI);
                    if (schemaSet != null && schemaSet.size() > 0) {
                        schemaLocations.put(namespaceURI, locationPrefix + schemaSet.iterator().next().getName());
                    }
                    this.modified = true;
                }
                catch (Exception ignored) {}
            }
            StringBuilder buf = new StringBuilder();
            String leadingSpaces = String.format("%" + (this.root.getQualifiedName().length() + 2) + "s", "");
            String indent = "    ";
            String newLine = "\n";
            buf.append(newLine);
            for (Map.Entry<String, String> entry : schemaLocations.entrySet()) {
                buf.append(leadingSpaces).append(indent).append(entry.getKey()).append(" ").append(entry.getValue()).append(newLine);
            }
            buf.append(leadingSpaces);
            value = buf.toString();
            if (attr != null) {
                this.root.remove(attr);
            }
            this.root.addAttribute(schemaLocationQName, value);
        }

        private String getLocationPrefix(Map<String, String> schemaLocations) {
            for (Map.Entry<String, String> entry : schemaLocations.entrySet()) {
                String uri = entry.getKey();
                String location = entry.getValue();
                Set<Schema> schemaSet = ConvertToUnqualifiedStyle.this.schemas.getNamespaceMappings().get(uri);
                if (schemaSet == null) continue;
                for (Schema schema : schemaSet) {
                    if (!location.endsWith(schema.getName())) continue;
                    return location.substring(0, location.length() - schema.getName().length());
                }
            }
            return "http://localhost:8080/schema/";
        }

        private Namespace getXsiNs() {
            Namespace xsi = null;
            for (Object o : this.root.declaredNamespaces()) {
                Namespace ns = (Namespace)o;
                if (!"http://www.w3.org/2001/XMLSchema-instance".equals(ns.getURI())) continue;
                xsi = ns;
                break;
            }
            if (xsi == null) {
                xsi = DocumentHelper.createNamespace((String)"xsi", (String)"http://www.w3.org/2001/XMLSchema-instance");
                this.root.add(xsi);
            }
            return xsi;
        }

        private void setNamespacePrefix(Element element, String namespaceURI) {
            String prefix = null;
            if (namespaceURI != null && this.namespaces.containsKey(namespaceURI)) {
                prefix = this.namespaces.get(namespaceURI).getPrefix();
            }
            if (prefix == null || !prefix.equals(element.getNamespacePrefix())) {
                element.setQName(QName.get((String)element.getName(), (String)prefix, (String)namespaceURI));
                this.modified = true;
            }
        }

        private void acceptSubElements(Element element) {
            for (Object subElement : element.elements()) {
                this.accept((Element)subElement);
            }
        }

        private String getContextNamespaceURI() {
            if (this.namespaceURIStack.isEmpty()) {
                return null;
            }
            return this.namespaceURIStack.peek();
        }
    }
}

