/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.springext.support.resolver;

import com.alibaba.citrus.springext.ConfigurationPoint;
import com.alibaba.citrus.springext.ConfigurationPoints;
import com.alibaba.citrus.util.Assert;
import org.springframework.beans.factory.xml.NamespaceHandler;
import org.springframework.beans.factory.xml.NamespaceHandlerResolver;

public class ConfigurationPointNamespaceHandlerResolver
implements NamespaceHandlerResolver {
    private final ConfigurationPoints cps;
    private final NamespaceHandlerResolver defaultResolver;

    public ConfigurationPointNamespaceHandlerResolver(ConfigurationPoints cps, NamespaceHandlerResolver defaultResolver) {
        this.cps = Assert.assertNotNull(cps, "configurationPoints", new Object[0]);
        this.defaultResolver = defaultResolver;
    }

    public NamespaceHandler resolve(String namespaceUri) {
        ConfigurationPoint cp = this.cps.getConfigurationPointByNamespaceUri(namespaceUri);
        if (cp != null) {
            return cp.getNamespaceHandler();
        }
        if (this.defaultResolver != null) {
            return this.defaultResolver.resolve(namespaceUri);
        }
        return null;
    }
}

