/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.springext.support;

import com.alibaba.citrus.springext.ConfigurationPoint;
import com.alibaba.citrus.springext.ConfigurationPoints;
import com.alibaba.citrus.springext.Contribution;
import com.alibaba.citrus.springext.ResourceResolver;
import com.alibaba.citrus.springext.Schema;
import com.alibaba.citrus.springext.Schemas;
import com.alibaba.citrus.springext.impl.ConfigurationPointImpl;
import com.alibaba.citrus.springext.impl.ConfigurationPointsImpl;
import com.alibaba.citrus.springext.impl.SpringPluggableSchemas;
import com.alibaba.citrus.springext.support.ConfigurationPointSchemaSourceInfo;
import com.alibaba.citrus.springext.support.ContributionSchemaSourceInfo;
import com.alibaba.citrus.springext.support.SchemaSet;
import com.alibaba.citrus.springext.support.SchemaUtil;
import com.alibaba.citrus.springext.support.SpringPluggableSchemaSourceInfo;
import com.alibaba.citrus.util.Assert;
import com.alibaba.citrus.util.CollectionUtil;
import com.alibaba.citrus.util.ToStringBuilder;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpringExtSchemaSet
extends SchemaSet {
    private NamespaceItem[] treeItems;
    private Map<String, IncludedSchemaInfo> includedSchemaInfoMap;

    public SpringExtSchemaSet() {
        this(new ConfigurationPointsImpl(), new SpringPluggableSchemas());
    }

    public SpringExtSchemaSet(ClassLoader classLoader) {
        this(new ConfigurationPointsImpl(classLoader), new SpringPluggableSchemas(classLoader));
    }

    public SpringExtSchemaSet(ResourceResolver resourceResolver) {
        this(new ConfigurationPointsImpl(resourceResolver), new SpringPluggableSchemas(resourceResolver));
    }

    SpringExtSchemaSet(String location) {
        this(new ConfigurationPointsImpl((ClassLoader)null, location), new SpringPluggableSchemas());
    }

    private SpringExtSchemaSet(ConfigurationPointsImpl configurationPoints, SpringPluggableSchemas springPluggableSchemas) {
        super(configurationPoints, springPluggableSchemas);
    }

    public ConfigurationPoints getConfigurationPoints() {
        for (Schemas schemas : this) {
            if (!(schemas instanceof ConfigurationPoints)) continue;
            return (ConfigurationPoints)schemas;
        }
        Assert.unreachableCode("no ConfigurationPoints found", new Object[0]);
        return null;
    }

    @Override
    protected void foundIncludes(Schema schema, Collection<Schema> allIncludes) {
        Contribution contribution;
        if (schema instanceof ContributionSchemaSourceInfo && (contribution = (Contribution)((ContributionSchemaSourceInfo)((Object)schema)).getParent()) != null) {
            for (Schema includedSchema : allIncludes) {
                String includedSchemaName;
                IncludedSchemaInfo includedSchemaInfo;
                if (!(includedSchema instanceof SpringPluggableSchemaSourceInfo)) continue;
                if (this.includedSchemaInfoMap == null) {
                    this.includedSchemaInfoMap = CollectionUtil.createHashMap();
                }
                if ((includedSchemaInfo = this.includedSchemaInfoMap.get(includedSchemaName = includedSchema.getName())) == null) {
                    includedSchemaInfo = new IncludedSchemaInfo(includedSchema);
                    this.includedSchemaInfoMap.put(includedSchemaName, includedSchemaInfo);
                }
                includedSchemaInfo.includingContributions.put(schema.getName(), contribution);
            }
        }
    }

    @Override
    protected void finishProcessIncludes() {
        if (this.includedSchemaInfoMap != null) {
            for (final IncludedSchemaInfo includedSchemaInfo : this.includedSchemaInfoMap.values()) {
                Schema includedSchema = includedSchemaInfo.getIncludedSchema();
                includedSchema.transform(SchemaUtil.getAnyElementTransformer(this.getConfigurationPoints(), new SchemaUtil.AnyElementVisitor(){

                    public void visitAnyElement(ConfigurationPoint cp) {
                        for (Contribution contribution : includedSchemaInfo) {
                            if (!(cp instanceof ConfigurationPointImpl)) continue;
                            ((ConfigurationPointImpl)cp).addDependingContribution(contribution);
                        }
                    }
                }), true);
            }
        }
        this.includedSchemaInfoMap = null;
    }

    public synchronized NamespaceItem[] getIndependentItems() {
        if (this.treeItems == null) {
            this.treeItems = new TreeBuilder().build();
        }
        return this.treeItems;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TreeBuilder {
        private final Map<String, Set<Schema>> namespaceMappings;
        private final Map<String, NamespaceItem> items;
        private final Map<String, NamespaceItem> independentItems;
        private final LinkedList<String> buildingNamespaces;

        private TreeBuilder() {
            this.namespaceMappings = SpringExtSchemaSet.this.getNamespaceMappings();
            this.items = CollectionUtil.createHashMap();
            this.independentItems = CollectionUtil.createTreeMap();
            this.buildingNamespaces = CollectionUtil.createLinkedList();
        }

        public NamespaceItem[] build() {
            for (String namespace : this.namespaceMappings.keySet()) {
                this.buildNamespaceItemRecursively(namespace);
            }
            return this.independentItems.values().toArray(new NamespaceItem[this.independentItems.size()]);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean buildNamespaceItemRecursively(@NotNull String namespace) {
            if (this.buildingNamespaces.contains(namespace)) {
                return false;
            }
            try {
                this.buildingNamespaces.push(namespace);
                this.buildNamespaceItem(namespace);
            }
            finally {
                this.buildingNamespaces.pop();
            }
            return true;
        }

        private void buildNamespaceItem(@NotNull String namespace) {
            if (this.items.containsKey(namespace)) {
                return;
            }
            Set<Schema> schemas = this.namespaceMappings.get(namespace);
            Assert.assertTrue(schemas != null, "%s not exist", namespace);
            Schema schema = null;
            if (!schemas.isEmpty()) {
                schema = schemas.iterator().next();
            }
            if (schema == null || schema instanceof SpringPluggableSchemaSourceInfo) {
                this.buildSpringPluggableItem(namespace, schemas);
            } else if (schema instanceof ConfigurationPointSchemaSourceInfo) {
                this.buildConfigurationPointItem(namespace, schemas, (ConfigurationPointSchemaSourceInfo)((Object)schema));
            } else {
                Assert.unreachableCode();
            }
        }

        private void buildSpringPluggableItem(@NotNull String namespace, @NotNull Set<Schema> schemas) {
            SpringPluggableItem item = new SpringPluggableItem(namespace, schemas);
            this.items.put(namespace, item);
            this.independentItems.put(namespace, item);
        }

        private void buildConfigurationPointItem(String namespace, Set<Schema> schemas, ConfigurationPointSchemaSourceInfo schema) {
            ConfigurationPoint configurationPoint = (ConfigurationPoint)schema.getParent();
            ConfigurationPointItem item = new ConfigurationPointItem(namespace, schemas, configurationPoint);
            this.items.put(namespace, item);
            Collection<Contribution> dependingContributions = configurationPoint.getDependingContributions();
            int count = 0;
            for (Contribution contribution : dependingContributions) {
                String dependingNamespace = contribution.getConfigurationPoint().getNamespaceUri();
                if (!this.buildNamespaceItemRecursively(dependingNamespace)) continue;
                ++count;
                NamespaceItem parentItem = Assert.assertNotNull(this.items.get(dependingNamespace), "no item for namespace %s", namespace);
                if (!(parentItem instanceof ConfigurationPointItem)) continue;
                item = this.buildContributionItem(namespace, item, contribution, (ConfigurationPointItem)parentItem);
            }
            if (count == 0) {
                this.independentItems.put(namespace, item);
            }
        }

        private ConfigurationPointItem buildContributionItem(String namespace, ConfigurationPointItem item, Contribution contribution, ConfigurationPointItem parentItem) {
            String contributionName = contribution.getName();
            ContributionItem parentContributionItem = (ContributionItem)parentItem.children.get(contributionName);
            if (parentContributionItem == null) {
                parentContributionItem = new ContributionItem(contribution);
                parentItem.children.put(contributionName, parentContributionItem);
            }
            if (!parentContributionItem.children.containsKey(namespace)) {
                parentContributionItem.children.put(namespace, item);
            }
            return item;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class AbstractNamespaceItem<C extends TreeItem>
    extends AbstractTreeItem<C>
    implements NamespaceItem {
        private final String namespace;
        private final Set<Schema> schemas;

        protected AbstractNamespaceItem(@NotNull String namespace, @NotNull Set<Schema> schemas) {
            this.namespace = namespace;
            this.schemas = schemas;
        }

        @Override
        @NotNull
        public String getNamespace() {
            return this.namespace;
        }

        @Override
        @NotNull
        public Set<Schema> getSchemas() {
            return this.schemas;
        }

        public String toString() {
            return this.namespace;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class AbstractTreeItem<C extends TreeItem>
    implements TreeItem,
    ParentOf<C> {
        protected final Map<String, C> children = CollectionUtil.createTreeMap();

        private AbstractTreeItem() {
        }

        @Override
        public boolean hasChildren() {
            return !this.children.isEmpty();
        }

        @Override
        @NotNull
        public TreeItem[] getChildren() {
            return this.children.values().toArray(new TreeItem[this.children.size()]);
        }

        @NotNull
        public String dump() {
            ToStringBuilder buf = new ToStringBuilder();
            this.dump(buf);
            return buf.toString();
        }

        void dump(ToStringBuilder buf) {
            buf.append(this).start("{", "}");
            int i = 0;
            for (TreeItem child : this.getChildren()) {
                if (i++ > 0) {
                    buf.append("\n");
                }
                ((AbstractTreeItem)child).dump(buf);
            }
            buf.end();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SpringPluggableItem
    extends AbstractNamespaceItem<TreeItem> {
        public SpringPluggableItem(@NotNull String namespace, @NotNull Set<Schema> schemas) {
            super(namespace, schemas);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ContributionItem
    extends AbstractTreeItem<ConfigurationPointItem> {
        private final Contribution contribution;

        public ContributionItem(@NotNull Contribution contribution) {
            this.contribution = contribution;
        }

        @NotNull
        public Contribution getContribution() {
            return this.contribution;
        }

        public String toString() {
            return this.contribution.getName();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ConfigurationPointItem
    extends AbstractNamespaceItem<ContributionItem> {
        private final ConfigurationPoint configurationPoint;

        public ConfigurationPointItem(@NotNull String namespace, @NotNull Set<Schema> schemas, @NotNull ConfigurationPoint configurationPoint) {
            super(namespace, schemas);
            this.configurationPoint = configurationPoint;
        }

        @NotNull
        public ConfigurationPoint getConfigurationPoint() {
            return this.configurationPoint;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ParentOf<C extends TreeItem> {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface NamespaceItem
    extends TreeItem {
        @NotNull
        public String getNamespace();

        @NotNull
        public Set<Schema> getSchemas();
    }

    public static interface TreeItem {
        public boolean hasChildren();

        @NotNull
        public TreeItem[] getChildren();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class IncludedSchemaInfo
    implements Iterable<Contribution> {
        private final Map<String, Contribution> includingContributions = CollectionUtil.createHashMap();
        private final Schema includedSchema;

        private IncludedSchemaInfo(Schema includedSchema) {
            this.includedSchema = includedSchema;
        }

        public Schema getIncludedSchema() {
            return this.includedSchema;
        }

        @Override
        public Iterator<Contribution> iterator() {
            return this.includingContributions.values().iterator();
        }
    }
}

