/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.springext.support;

import com.alibaba.citrus.springext.Namespaces;
import com.alibaba.citrus.springext.Schema;
import com.alibaba.citrus.springext.Schemas;
import com.alibaba.citrus.springext.support.SchemaUtil;
import com.alibaba.citrus.util.ArrayUtil;
import com.alibaba.citrus.util.Assert;
import com.alibaba.citrus.util.CollectionUtil;
import com.alibaba.citrus.util.StringUtil;
import com.alibaba.citrus.util.ToStringBuilder;
import com.alibaba.citrus.util.internal.LazyLoader;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SchemaSet
implements Schemas,
Namespaces,
Iterable<Schemas> {
    private final List<Schemas> allSchemas;
    private final Map<String, Schema> nameToSchemas = CollectionUtil.createHashMap();
    private final Map<String, Schema> nameToSchemasUnmodifiable = Collections.unmodifiableMap(this.nameToSchemas);
    private final SortedSet<String> names;
    private final SortedSet<String> namespaces;
    private final Set<String> namespacesUnmodifiable;
    private final LazyLoader<Map<String, Set<Schema>>, Object> nsToSchemas = LazyLoader.getDefault(new LazyLoader.Loader<Map<String, Set<Schema>>, Object>(){

        @Override
        public Map<String, Set<Schema>> load(Object context) {
            TreeMap<String, Set<Schema>> nsToSchemasMappings = CollectionUtil.createTreeMap();
            for (Schema schema : SchemaSet.this.nameToSchemas.values()) {
                String namespace = schema.getTargetNamespace();
                if (namespace == null) continue;
                TreeSet<Schema> nsSchemas = (TreeSet<Schema>)nsToSchemasMappings.get(namespace);
                if (nsSchemas == null) {
                    nsSchemas = CollectionUtil.createTreeSet(new Comparator<Schema>(){

                        @Override
                        public int compare(Schema o1, Schema o2) {
                            return o2.getName().compareTo(o1.getName());
                        }
                    });
                    nsToSchemasMappings.put(namespace, nsSchemas);
                    SchemaSet.this.namespaces.add(namespace);
                }
                nsSchemas.add(schema);
            }
            for (Schemas schemas : SchemaSet.this.allSchemas) {
                if (!(schemas instanceof Namespaces)) continue;
                for (String namespace : ((Namespaces)((Object)schemas)).getAvailableNamespaces()) {
                    if (nsToSchemasMappings.containsKey(namespace)) continue;
                    nsToSchemasMappings.put(namespace, Collections.emptySet());
                    SchemaSet.this.namespaces.add(namespace);
                }
            }
            return Collections.unmodifiableMap(nsToSchemasMappings);
        }
    });

    public static SchemaSet getInstance(Schemas ... schemasList) {
        if (schemasList != null && schemasList.length == 1 && schemasList[0] instanceof SchemaSet) {
            return (SchemaSet)schemasList[0];
        }
        return new SchemaSet(schemasList);
    }

    public SchemaSet(Schemas ... schemasList) {
        Assert.assertTrue(!ArrayUtil.isEmptyArray(schemasList), "schemasList", new Object[0]);
        this.allSchemas = CollectionUtil.createArrayList(schemasList);
        for (Schemas schemas : schemasList) {
            this.nameToSchemas.putAll(schemas.getNamedMappings());
        }
        this.names = CollectionUtil.createTreeSet(new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                int lengthCompare = o2.length() - o1.length();
                if (lengthCompare == 0) {
                    return o1.compareTo(o2);
                }
                return lengthCompare;
            }
        }, this.nameToSchemas.keySet());
        this.namespaces = CollectionUtil.createTreeSet();
        this.namespacesUnmodifiable = Collections.unmodifiableSet(this.namespaces);
        this.processIncludes();
    }

    @Override
    public Iterator<Schemas> iterator() {
        return this.allSchemas.iterator();
    }

    @Override
    public Set<String> getAvailableNamespaces() {
        this.nsToSchemas.getInstance();
        return this.namespacesUnmodifiable;
    }

    private void processIncludes() {
        class SchemaIncludes {
            Map<String, Schema> allIncludes;
            boolean removeAllIncludes;

            SchemaIncludes() {
            }
        }
        HashMap<String, SchemaIncludes> nameToSchemaIncludes = CollectionUtil.createHashMap();
        for (Schema schema : CollectionUtil.createArrayList(this.nameToSchemas.values())) {
            Map<String, Schema> allIncludes = this.getAllIncludes(schema);
            Map<String, Schema.Element> allElements = this.getAllElements(schema, allIncludes.values());
            boolean withIndirectIncludes = false;
            this.foundIncludes(schema, allIncludes.values());
            for (Schema includedSchema : allIncludes.values()) {
                if (includedSchema.getIncludes().length <= 0) continue;
                withIndirectIncludes = true;
                SchemaIncludes si = (SchemaIncludes)nameToSchemaIncludes.get(includedSchema.getName());
                if (si == null) {
                    si = new SchemaIncludes();
                    nameToSchemaIncludes.put(includedSchema.getName(), si);
                }
                si.removeAllIncludes = true;
            }
            if (withIndirectIncludes) {
                SchemaIncludes si = (SchemaIncludes)nameToSchemaIncludes.get(schema.getName());
                if (si == null) {
                    si = new SchemaIncludes();
                    nameToSchemaIncludes.put(schema.getName(), si);
                }
                si.allIncludes = allIncludes;
            }
            schema.setElements(allElements.values());
        }
        for (Map.Entry entry : nameToSchemaIncludes.entrySet()) {
            Schema schema = this.nameToSchemas.get(entry.getKey());
            SchemaIncludes si = (SchemaIncludes)entry.getValue();
            if (si.removeAllIncludes) {
                schema.transform(SchemaUtil.getTransformerWhoRemovesIncludes(), true);
                continue;
            }
            if (si.allIncludes == null) continue;
            schema.transform(SchemaUtil.getTransformerWhoAddsIndirectIncludes(si.allIncludes), true);
        }
        this.finishProcessIncludes();
    }

    protected void foundIncludes(Schema schema, Collection<Schema> allIncludes) {
    }

    protected void finishProcessIncludes() {
    }

    private Map<String, Schema.Element> getAllElements(Schema schema, Collection<Schema> includes) {
        HashMap<String, Schema.Element> all = CollectionUtil.createHashMap();
        for (Schema.Element element : schema.getElements()) {
            all.put(element.getName(), element);
        }
        for (Schema include : includes) {
            for (Schema.Element element : include.getElements()) {
                all.put(element.getName(), element);
            }
        }
        return all;
    }

    private Map<String, Schema> getAllIncludes(Schema schema) {
        LinkedHashMap<String, Schema> includes = CollectionUtil.createLinkedHashMap();
        this.getAllIncludesDepthFirst(schema, includes);
        includes.remove(schema.getName());
        return includes;
    }

    private void getAllIncludesDepthFirst(Schema schema, Map<String, Schema> includes) {
        for (String include : schema.getIncludes()) {
            Schema includedSchema = this.findIncludedSchema(include, schema.getName());
            this.getAllIncludesDepthFirst(includedSchema, includes);
        }
        includes.put(schema.getName(), schema);
    }

    private Schema findIncludedSchema(String include, String fromSchema) {
        return Assert.assertNotNull(this.findSchema(include), "Could not include schema \"%s\" in %s", include, fromSchema);
    }

    public void addSchema(Schema schema) {
        this.nameToSchemas.put(schema.getName(), schema);
        this.names.add(schema.getName());
    }

    @Override
    public Map<String, Schema> getNamedMappings() {
        return this.nameToSchemasUnmodifiable;
    }

    public Map<String, Set<Schema>> getNamespaceMappings() {
        return this.nsToSchemas.getInstance();
    }

    public Schema findSchema(String systemId) {
        systemId = Assert.assertNotNull(StringUtil.trimToNull(systemId), "systemId", new Object[0]).replaceAll("\\\\", "/");
        try {
            systemId = URI.create(systemId).normalize().toString();
        }
        catch (Exception e) {
            // empty catch block
        }
        for (String schemaName : this.names) {
            if (!systemId.endsWith(schemaName)) continue;
            return this.nameToSchemas.get(schemaName);
        }
        return null;
    }

    public void transformAll(Schema.Transformer transformer) {
        if (transformer == null) {
            transformer = SchemaUtil.getNoopTransformer();
        }
        for (Schema schema : this.nameToSchemas.values()) {
            schema.transform(transformer, true);
        }
    }

    public String toString() {
        return new ToStringBuilder().append("SchemaSet").append(this.names).toString();
    }
}

