/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.service.resource.loader;

import com.alibaba.citrus.service.resource.Resource;
import com.alibaba.citrus.service.resource.ResourceLister;
import com.alibaba.citrus.service.resource.ResourceListerContext;
import com.alibaba.citrus.service.resource.ResourceLoaderContext;
import com.alibaba.citrus.service.resource.ResourceLoadingOption;
import com.alibaba.citrus.service.resource.ResourceLoadingService;
import com.alibaba.citrus.service.resource.ResourceMatchResult;
import com.alibaba.citrus.util.FileUtil;
import com.alibaba.citrus.util.StringUtil;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SuperResourceLoader
implements ResourceLister {
    private String newResourceName;

    public void setName(String resourceName) {
        this.newResourceName = StringUtil.trimToNull(resourceName);
    }

    @Override
    public void init(ResourceLoadingService resourceLoadingService) {
    }

    @Override
    public Resource getResource(ResourceLoaderContext context, Set<ResourceLoadingOption> options) {
        return context.getResource(this.getNewResourceName(context), options);
    }

    @Override
    public String[] list(ResourceListerContext context, Set<ResourceLoadingOption> options) {
        return context.list(this.getNewResourceName(context), options);
    }

    private String getNewResourceName(ResourceMatchResult context) {
        String resourceName = "";
        if (this.newResourceName != null) {
            resourceName = this.newResourceName;
        }
        resourceName = FileUtil.normalizeAbsolutePath(context.substitute(resourceName));
        return resourceName;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.getClass().getSimpleName()).append("[");
        if (this.newResourceName != null) {
            buf.append(this.newResourceName);
        }
        buf.append("]");
        return buf.toString();
    }
}

