/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.service.resource.impl;

import com.alibaba.citrus.service.resource.Resource;
import com.alibaba.citrus.service.resource.ResourceFilterChain;
import com.alibaba.citrus.service.resource.ResourceLoaderContext;
import com.alibaba.citrus.service.resource.ResourceLoadingOption;
import com.alibaba.citrus.service.resource.ResourceLoadingService;
import com.alibaba.citrus.service.resource.ResourceMatchResult;
import com.alibaba.citrus.service.resource.ResourceNotFoundException;
import com.alibaba.citrus.service.resource.ResourceTrace;
import com.alibaba.citrus.service.resource.ResourceTraceElement;
import com.alibaba.citrus.service.resource.impl.AbstractResourceLoadingContext;
import com.alibaba.citrus.service.resource.impl.ResourceFilterMapping;
import com.alibaba.citrus.service.resource.impl.ResourceLoaderMapping;
import com.alibaba.citrus.service.resource.impl.ResourceMapping;
import com.alibaba.citrus.util.Assert;
import com.alibaba.citrus.util.CollectionUtil;
import com.alibaba.citrus.util.regex.MatchResultSubstitution;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ResourceLoaderContextImpl
extends AbstractResourceLoadingContext<Resource>
implements ResourceLoaderContext,
ResourceFilterChain {
    private final String configLocation;
    private final String beanName;
    private final ResourceFilterMapping[] filterMappings;
    private final BestFiltersMatcher filtersMatcher;
    private List<ResourceTraceElement> trace;

    public ResourceLoaderContextImpl(String resourceName, Set<ResourceLoadingOption> options, ResourceFilterMapping[] filterMappings, ResourceMapping[] mappings, ResourceLoadingService parent, Logger log, String configLocation, String beanName) {
        super(resourceName, options, mappings, parent, log);
        this.configLocation = configLocation;
        this.beanName = beanName;
        this.filterMappings = Assert.assertNotNull(filterMappings, "filterMappings", new Object[0]);
        this.filtersMatcher = new BestFiltersMatcher();
    }

    public Resource getResource() throws ResourceNotFoundException {
        if (this.filtersMatcher.matches(this.resourceName)) {
            ResourceFilterMapping filterMapping = (ResourceFilterMapping)this.filtersMatcher.bestMatchPettern;
            this.lastMatchedPattern = filterMapping;
            this.lastSubstitution = new MatchResultSubstitution(this.filtersMatcher.bestMatchResult);
            this.log.debug("Resource \"{}\" matched resource-filters pattern: \"{}\"", (Object)this.resourceName, (Object)filterMapping.getPatternName());
            ResourceLoaderContextImpl root = this;
            ResourceLoaderContextImpl matchResult = this;
            ResourceFilterChain chain = filterMapping.getResourceFilterChain(root);
            return chain.doFilter(matchResult, this.options);
        }
        return (Resource)this.doLoad(this.resourceName, this.options);
    }

    public ResourceTrace getTrace() throws ResourceNotFoundException {
        this.trace = CollectionUtil.createLinkedList();
        Resource resource = null;
        try {
            resource = (Resource)this.doLoad(this.resourceName, this.options);
        }
        catch (ResourceNotFoundException resourceNotFoundException) {
            // empty catch block
        }
        return new ResourceTrace(this.trace, resource);
    }

    @Override
    public Resource doFilter(ResourceMatchResult filterMatchResult, Set<ResourceLoadingOption> options) throws ResourceNotFoundException {
        return (Resource)this.doLoad(filterMatchResult.getResourceName(), options);
    }

    @Override
    protected void visitMapping(ResourceMapping mapping) {
        if (this.trace != null) {
            this.trace.add(new ResourceTraceElement(this.configLocation, this.beanName, mapping.getPatternType(), mapping.getPatternName(), mapping.isInternal(), this.resourceName));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Resource loadParentResource(String resourceName, Set<ResourceLoadingOption> options) throws ResourceNotFoundException {
        if (this.parent != null) {
            try {
                Resource resource = this.parent.getResource(resourceName, options);
                return resource;
            }
            finally {
                ResourceTrace parentTrace;
                if (this.trace != null && (parentTrace = this.parent.trace(resourceName, options)) != null) {
                    for (ResourceTraceElement element : parentTrace) {
                        this.trace.add(element);
                    }
                }
            }
        }
        return null;
    }

    @Override
    protected Resource loadMappedResource(ResourceLoaderMapping mapping, Set<ResourceLoadingOption> options) {
        return mapping.getResource(this, options);
    }

    @Override
    public Resource getResource(String newResourceName, Set<ResourceLoadingOption> newOptions) {
        return (Resource)this.loadContextResource(newResourceName, newOptions);
    }

    public String toString() {
        return "ResourceLoaderContext[" + this.resourceName + "]";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class BestFiltersMatcher
    extends AbstractResourceLoadingContext.BestMatcher<ResourceFilterMapping> {
        private int i;

        private BestFiltersMatcher() {
        }

        @Override
        protected void init() {
            this.i = 0;
        }

        @Override
        protected ResourceFilterMapping nextPattern() {
            if (this.i < ResourceLoaderContextImpl.this.filterMappings.length) {
                return ResourceLoaderContextImpl.this.filterMappings[this.i++];
            }
            return null;
        }

        @Override
        protected boolean accept(ResourceFilterMapping pattern) {
            return true;
        }
    }
}

