/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.service.requestcontext.session.store.cookie;

import com.alibaba.citrus.service.requestcontext.session.SessionConfig;
import com.alibaba.citrus.service.requestcontext.session.store.cookie.CookieStore;
import com.alibaba.citrus.service.requestcontext.util.CookieSupport;
import com.alibaba.citrus.util.Assert;
import com.alibaba.citrus.util.ObjectUtil;
import com.alibaba.citrus.util.StringUtil;
import com.alibaba.citrus.util.ToStringBuilder;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCookieStore
implements CookieStore {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private String storeName;
    private SessionConfig.CookieConfig idCookieConfig;
    private String name;
    private String domain;
    private String path;
    private Integer maxAge;
    private Boolean httpOnly;
    private Boolean secure;
    private Boolean survivesInInvalidating;

    public String getStoreName() {
        return this.storeName;
    }

    public SessionConfig.CookieConfig getIdCookieConfig() {
        return this.idCookieConfig;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public int getMaxAge() {
        return this.maxAge;
    }

    public void setMaxAge(int maxAge) {
        this.maxAge = maxAge;
    }

    public boolean isHttpOnly() {
        return this.httpOnly;
    }

    public void setHttpOnly(boolean httpOnly) {
        this.httpOnly = httpOnly;
    }

    public boolean getSecure() {
        return this.secure;
    }

    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    public boolean isSurvivesInInvalidating() {
        return this.survivesInInvalidating;
    }

    public void setSurvivesInInvalidating(boolean survivesInInvalidating) {
        this.survivesInInvalidating = survivesInInvalidating;
    }

    public final void init(String storeName, SessionConfig sessionConfig) throws Exception {
        this.idCookieConfig = Assert.assertNotNull(sessionConfig, "sessionConfig", new Object[0]).getId().getCookie();
        this.storeName = storeName;
        if (StringUtil.isEmpty(this.name)) {
            throw new IllegalArgumentException("missing cookie name for store: " + storeName);
        }
        this.domain = StringUtil.defaultIfEmpty(this.domain, this.idCookieConfig.getDomain());
        this.path = StringUtil.defaultIfEmpty(this.path, this.idCookieConfig.getPath());
        this.maxAge = ObjectUtil.defaultIfNull(this.maxAge, this.idCookieConfig.getMaxAge());
        this.httpOnly = ObjectUtil.defaultIfNull(this.httpOnly, this.idCookieConfig.isHttpOnly());
        this.secure = ObjectUtil.defaultIfNull(this.secure, this.idCookieConfig.isSecure());
        this.survivesInInvalidating = ObjectUtil.defaultIfNull(this.survivesInInvalidating, SURVIVES_IN_INVALIDATING_DEFAULT);
        if (this.survivesInInvalidating.booleanValue() && this.maxAge <= 0) {
            throw new IllegalArgumentException("Cookie store which Survives In Invalidating must specify MaxAge of cookie");
        }
        this.init();
    }

    protected void init() throws Exception {
    }

    protected void writeCookie(HttpServletResponse response, String cookieName, String cookieValue) {
        CookieSupport cookie = new CookieSupport(cookieName, cookieValue);
        if (!StringUtil.isEmpty(this.domain)) {
            cookie.setDomain(this.domain);
        }
        if (!StringUtil.isEmpty(this.path)) {
            cookie.setPath(this.path);
        }
        if (this.maxAge > 0) {
            cookie.setMaxAge(this.maxAge);
        }
        cookie.setHttpOnly(this.httpOnly);
        cookie.setSecure(this.secure);
        this.log.debug("{}", (Object)cookie);
        cookie.addCookie(response);
    }

    public final String toString() {
        ToStringBuilder.MapBuilder mb = new ToStringBuilder.MapBuilder();
        this.toString(mb);
        return new ToStringBuilder().append("CookieStore").append(mb).toString();
    }

    protected void toString(ToStringBuilder.MapBuilder mb) {
        mb.append("name", this.name);
        mb.append("domain", this.domain);
        mb.append("path", this.path);
        mb.append("maxAge", String.format("%,d seconds", this.maxAge));
        mb.append("httpOnly", this.httpOnly);
        mb.append("secure", this.secure);
        mb.append("survivesInInvalidating", this.survivesInInvalidating);
    }
}

