/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.service.requestcontext.session.interceptor;

import com.alibaba.citrus.logconfig.support.SecurityLogger;
import com.alibaba.citrus.service.requestcontext.session.SessionConfig;
import com.alibaba.citrus.service.requestcontext.session.interceptor.AbstractSessionAttributeAccessController;
import com.alibaba.citrus.springext.support.parser.AbstractSingleBeanDefinitionParser;
import com.alibaba.citrus.springext.util.DomUtil;
import com.alibaba.citrus.springext.util.SpringExtUtil;
import com.alibaba.citrus.util.ClassUtil;
import com.alibaba.citrus.util.CollectionUtil;
import com.alibaba.citrus.util.StringUtil;
import java.util.Map;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SessionAttributeWhitelist
extends AbstractSessionAttributeAccessController {
    private final SecurityLogger log = new SecurityLogger();
    private Map<String, Class<?>> allowedAttributes;

    public void setLogName(String name) {
        this.log.setLogName(name);
    }

    public void setAllowedAttributes(Map<String, Class<?>> allowedAttributes) {
        this.allowedAttributes = allowedAttributes;
    }

    @Override
    public void init(SessionConfig sessionConfig) {
        super.init(sessionConfig);
        if (this.allowedAttributes == null) {
            this.allowedAttributes = CollectionUtil.createHashMap();
        }
        for (Map.Entry<String, Class<?>> entry : this.allowedAttributes.entrySet()) {
            if (entry.getValue() == null) {
                entry.setValue(Object.class);
                continue;
            }
            entry.setValue(ClassUtil.getWrapperTypeIfPrimitive(entry.getValue()));
        }
    }

    @Override
    protected boolean allowForAttribute(String name, Class<?> type) {
        Class<?> allowedType = this.allowedAttributes.get(name);
        if (allowedType == null) {
            return false;
        }
        if (type == null) {
            return true;
        }
        return allowedType.isAssignableFrom(type);
    }

    @Override
    protected Object readInvalidAttribute(String name, Object value) {
        this.log.getLogger().warn("Attribute to read is not in whitelist: name={}, type={}", (Object)name, (Object)(value == null ? "unknwon" : value.getClass().getName()));
        return value;
    }

    @Override
    protected Object writeInvalidAttribute(String name, Object value) {
        this.log.getLogger().warn("Attribute to write is not in whitelist: name={}, type={}", (Object)name, (Object)(value == null ? "unknwon" : value.getClass().getName()));
        return value;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DefinitionParser
    extends AbstractSingleBeanDefinitionParser<SessionAttributeWhitelist> {
        protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
            SpringExtUtil.attributesToProperties(element, builder, new String[0]);
            Map<Object, Object> allowedAttrs = SpringExtUtil.createManagedMap(element, parserContext);
            for (Element subElement : DomUtil.subElements(element, DomUtil.and(DomUtil.sameNs(element), DomUtil.name("attribute")))) {
                String name = StringUtil.trimToNull(subElement.getAttribute("name"));
                String type = StringUtil.trimToNull(subElement.getAttribute("type"));
                allowedAttrs.put(name, type);
            }
            builder.addPropertyValue("allowedAttributes", allowedAttrs);
        }
    }
}

