/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.service.requestcontext.session.impl;

import com.alibaba.citrus.service.requestcontext.session.HttpHeaderSessionStore;
import com.alibaba.citrus.service.requestcontext.session.SessionAttributeInterceptor;
import com.alibaba.citrus.service.requestcontext.session.SessionConfig;
import com.alibaba.citrus.service.requestcontext.session.SessionInterceptor;
import com.alibaba.citrus.service.requestcontext.session.SessionLifecycleListener;
import com.alibaba.citrus.service.requestcontext.session.SessionModel;
import com.alibaba.citrus.service.requestcontext.session.SessionModelEncoder;
import com.alibaba.citrus.service.requestcontext.session.SessionRequestContext;
import com.alibaba.citrus.service.requestcontext.session.SessionStore;
import com.alibaba.citrus.service.requestcontext.session.impl.SessionAttribute;
import com.alibaba.citrus.service.requestcontext.session.impl.SessionModelImpl;
import com.alibaba.citrus.util.Assert;
import com.alibaba.citrus.util.CollectionUtil;
import com.alibaba.citrus.util.ObjectUtil;
import com.alibaba.citrus.util.StringUtil;
import com.alibaba.citrus.util.ToStringBuilder;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SessionImpl
implements HttpSession {
    private static final Logger log = LoggerFactory.getLogger(SessionImpl.class);
    private final HttpSessionInternal sessionInternal = new HttpSessionInternal();
    private String sessionID;
    private SessionRequestContext requestContext;
    private String modelKey;
    private SessionModelImpl model;
    private boolean isNew;
    private Map<String, SessionAttribute> attrs = CollectionUtil.createHashMap();
    private Map<String, Object> storeStates = CollectionUtil.createHashMap();
    private boolean invalidated = false;
    private boolean cleared = false;
    private Set<String> clearingStores = CollectionUtil.createHashSet();

    public SessionImpl(String sessionID, SessionRequestContext requestContext, boolean isNew, boolean create) {
        EventType event;
        this.sessionID = Assert.assertNotNull(sessionID, "no sessionID", new Object[0]);
        this.requestContext = requestContext;
        this.modelKey = requestContext.getSessionConfig().getModelKey();
        if (isNew) {
            event = EventType.CREATED;
            log.debug("No session ID was found in cookie or URL.  A new session will be created.");
            this.sessionInternal.invalidate();
        } else {
            this.model = (SessionModelImpl)this.sessionInternal.getAttribute(this.modelKey);
            if (this.model == null) {
                event = EventType.CREATED;
                log.debug("Session state was not found for sessionID \"{}\".  A new session will be created.", (Object)sessionID);
                isNew = true;
                this.sessionInternal.invalidate();
            } else {
                boolean expired = false;
                String modelSessionID = StringUtil.trimToNull(this.model.getSessionID());
                if (modelSessionID != null && !modelSessionID.equals(sessionID)) {
                    expired = true;
                    log.warn("Requested session ID \"{}\" does not match the ID in session model \"{}\".  Force expired the session.", (Object)sessionID, (Object)modelSessionID);
                }
                this.model.setSession(this);
                if (expired |= this.model.isExpired()) {
                    event = EventType.RECREATED;
                    if (log.isDebugEnabled()) {
                        log.debug("Session has expired: sessionID={}, created at {}, last accessed at {}, maxInactiveInterval={}, forceExpirationPeriod={}", new Object[]{modelSessionID, new Date(this.model.getCreationTime()), new Date(this.model.getLastAccessedTime()), this.model.getMaxInactiveInterval(), this.getSessionRequestContext().getSessionConfig().getForceExpirationPeriod()});
                    }
                    isNew = true;
                    this.sessionInternal.invalidate();
                } else {
                    event = EventType.VISITED;
                    if (log.isTraceEnabled()) {
                        log.trace("Activate session: sessionID={}, last accessed at {}, maxInactiveInterval={}", new Object[]{modelSessionID, new Date(this.model.getLastAccessedTime()), this.model.getMaxInactiveInterval()});
                    }
                    this.model.touch();
                }
            }
        }
        this.isNew = isNew;
        this.sessionInternal.setAttribute(this.modelKey, this.model);
        this.fireEvent(event);
    }

    public SessionRequestContext getSessionRequestContext() {
        return this.requestContext;
    }

    public SessionModel getSessionModel() {
        return this.model;
    }

    public String getId() {
        return this.sessionID;
    }

    public long getCreationTime() {
        this.assertValid("getCreationTime");
        return this.sessionInternal.getCreationTime();
    }

    public long getLastAccessedTime() {
        this.assertValid("getLastAccessedTime");
        return this.model.getLastAccessedTime();
    }

    public int getMaxInactiveInterval() {
        this.assertModel("getMaxInactiveInterval");
        return this.model.getMaxInactiveInterval();
    }

    public void setMaxInactiveInterval(int maxInactiveInterval) {
        this.assertModel("setMaxInactiveInterval");
        this.model.setMaxInactiveInterval(maxInactiveInterval);
    }

    public ServletContext getServletContext() {
        return this.requestContext.getServletContext();
    }

    public Object getAttribute(String name) {
        this.assertValid("getAttribute");
        return this.sessionInternal.getAttribute(name);
    }

    public Enumeration<String> getAttributeNames() {
        this.assertValid("getAttributeNames");
        Set<String> attrNames = this.getAttributeNameSet();
        final Iterator<String> i = attrNames.iterator();
        return new Enumeration<String>(){

            @Override
            public boolean hasMoreElements() {
                return i.hasNext();
            }

            @Override
            public String nextElement() {
                return (String)i.next();
            }
        };
    }

    private Set<String> getAttributeNameSet() {
        SessionConfig sessionConfig = this.requestContext.getSessionConfig();
        String[] storeNames = sessionConfig.getStores().getStoreNames();
        LinkedHashSet<String> attrNames = CollectionUtil.createLinkedHashSet();
        for (String storeName : storeNames) {
            SessionStore store = sessionConfig.getStores().getStore(storeName);
            for (String attrName : store.getAttributeNames(this.getId(), new StoreContextImpl(storeName))) {
                if (ObjectUtil.isEquals(attrName, this.modelKey)) continue;
                attrNames.add(attrName);
            }
        }
        for (SessionAttribute attr : this.attrs.values()) {
            if (attr.getValue() == null) {
                attrNames.remove(attr.getName());
                continue;
            }
            attrNames.add(attr.getName());
        }
        attrNames.remove(this.modelKey);
        return attrNames;
    }

    public void setAttribute(String name, Object value) {
        this.assertValid("setAttribute");
        this.assertAttributeNameForModification("setAttribute", name);
        this.sessionInternal.setAttribute(name, value);
    }

    public void removeAttribute(String name) {
        this.assertValid("removeAttribute");
        this.assertAttributeNameForModification("removeAttribute", name);
        this.setAttribute(name, null);
    }

    public void invalidate() {
        this.assertValid("invalidate");
        this.sessionInternal.invalidate();
        this.invalidated = true;
        this.fireEvent(EventType.INVALIDATED);
    }

    public void clear() {
        this.assertValid("clear");
        this.sessionInternal.invalidate();
    }

    public boolean isInvalidated() {
        return this.invalidated;
    }

    public boolean isNew() {
        this.assertValid("isNew");
        return this.isNew;
    }

    protected void assertModel(String methodName) {
        if (this.model == null) {
            throw new IllegalStateException("Cannot call method " + methodName + ": the session has not been initialized");
        }
    }

    protected void assertValid(String methodName) {
        this.assertModel(methodName);
        if (this.invalidated) {
            throw new IllegalStateException("Cannot call method " + methodName + ": the session has already invalidated");
        }
    }

    protected void assertAttributeNameForModification(String methodName, String attrName) {
        if (this.modelKey.equals(attrName)) {
            throw new IllegalArgumentException("Cannot call method " + methodName + " with attribute " + attrName);
        }
    }

    public void commit(boolean commitHeaders) {
        String[] storeNames = this.requestContext.getSessionConfig().getStores().getStoreNames();
        HashMap<String, StoreData> mappings = CollectionUtil.createHashMap();
        LinkedHashMap<String, StringBuilder> mayNotBeCommitted = null;
        boolean modified = false;
        for (Map.Entry<String, SessionAttribute> entry : this.attrs.entrySet()) {
            StringBuilder buf;
            String attrName = entry.getKey();
            SessionAttribute attr = entry.getValue();
            if (!attr.isModified()) continue;
            String storeName = attr.getStoreName();
            SessionStore store = attr.getStore();
            if (this.isApplicableToCommit(store, commitHeaders)) {
                StoreData data = (StoreData)mappings.get(storeName);
                if (data == null) {
                    data = new StoreData(storeName, store);
                    mappings.put(storeName, data);
                }
                Map storeAttrs = data.attrs;
                Object attrValue = attr.getValue();
                if (attrValue instanceof SessionModel) {
                    attrValue = this.requestContext.getSessionConfig().getSessionModelEncoders()[0].encode((SessionModel)attrValue);
                } else {
                    modified = true;
                }
                storeAttrs.put(attrName, attrValue);
                attr.setModified(false);
                continue;
            }
            if (commitHeaders) continue;
            if (mayNotBeCommitted == null) {
                mayNotBeCommitted = CollectionUtil.createLinkedHashMap();
            }
            if ((buf = (StringBuilder)mayNotBeCommitted.get(storeName)) == null) {
                buf = new StringBuilder();
                mayNotBeCommitted.put(storeName, buf);
            }
            if (buf.length() > 0) {
                buf.append(", ");
            }
            buf.append(attrName);
        }
        if (mayNotBeCommitted != null) {
            for (Map.Entry<String, SessionAttribute> entry : mayNotBeCommitted.entrySet()) {
                String storeName = entry.getKey();
                SessionStore store = this.requestContext.getSessionConfig().getStores().getStore(storeName);
                String attrNames = ((StringBuilder)((Object)entry.getValue())).toString();
                log.warn("The following attributes may not be saved in {}[id={}], because the response has already been committed: {}", new Object[]{store.getClass().getSimpleName(), storeName, attrNames});
            }
        }
        if (!(modified || this.cleared || this.requestContext.getSessionConfig().isKeepInTouch())) {
            return;
        }
        for (StoreData storeData : mappings.values()) {
            storeData.store.commit(storeData.attrs, this.getId(), new StoreContextImpl(storeData.storeName));
            this.clearingStores.remove(storeData.storeName);
        }
        if (this.cleared) {
            Iterator<String> i = this.clearingStores.iterator();
            while (i.hasNext()) {
                String string = i.next();
                SessionStore store = this.requestContext.getSessionConfig().getStores().getStore(string);
                if (this.isApplicableToCommit(store, commitHeaders)) {
                    Map<String, Object> storeAttrs = Collections.emptyMap();
                    store.commit(storeAttrs, this.sessionID, new StoreContextImpl(string));
                    i.remove();
                    continue;
                }
                if (commitHeaders) continue;
                log.warn("Session was cleared, but the data in {}[id={}] may not be cleared, because the response has already been committed.", (Object)store.getClass().getSimpleName(), (Object)string);
            }
        }
    }

    private boolean isApplicableToCommit(SessionStore store, boolean commitHeaders) {
        boolean isHttpHeaderStore = store instanceof HttpHeaderSessionStore;
        return commitHeaders == isHttpHeaderStore;
    }

    @Deprecated
    public HttpSessionContext getSessionContext() {
        throw new UnsupportedOperationException("No longer supported method: getSessionContext");
    }

    @Deprecated
    public Object getValue(String name) {
        return this.getAttribute(name);
    }

    @Deprecated
    public String[] getValueNames() {
        this.assertValid("getValueNames");
        Set<String> names = this.getAttributeNameSet();
        return names.toArray(new String[names.size()]);
    }

    @Deprecated
    public void putValue(String name, Object value) {
        this.setAttribute(name, value);
    }

    @Deprecated
    public void removeValue(String name) {
        this.removeAttribute(name);
    }

    public String toString() {
        ToStringBuilder.MapBuilder mb = new ToStringBuilder.MapBuilder();
        ToStringBuilder.MapBuilder attrsBuilder = new ToStringBuilder.MapBuilder().setPrintCount(true).setSortKeys(true);
        mb.append("sessionID", this.sessionID);
        mb.append("model", this.model);
        mb.append("isNew", this.isNew);
        mb.append("invalidated", this.invalidated);
        attrsBuilder.appendAll(this.attrs);
        attrsBuilder.remove(this.modelKey);
        mb.append("attrs", attrsBuilder);
        return new ToStringBuilder().append("HttpSession").append(mb).toString();
    }

    private void fireEvent(EventType event) {
        for (SessionInterceptor l : this.getSessionRequestContext().getSessionConfig().getSessionInterceptors()) {
            if (!(l instanceof SessionLifecycleListener)) continue;
            SessionLifecycleListener listener = (SessionLifecycleListener)l;
            try {
                switch (event) {
                    case RECREATED: {
                        listener.sessionInvalidated(this);
                    }
                    case CREATED: {
                        listener.sessionCreated(this);
                    }
                    case VISITED: {
                        listener.sessionVisited(this);
                        break;
                    }
                    case INVALIDATED: {
                        listener.sessionInvalidated(this);
                        break;
                    }
                    default: {
                        Assert.unreachableCode();
                        break;
                    }
                }
            }
            catch (Exception e) {
                log.error("Listener \"" + listener.getClass().getSimpleName() + "\" failed", (Throwable)e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class HttpSessionInternal
    implements HttpSession {
        private HttpSessionInternal() {
        }

        public String getId() {
            return SessionImpl.this.getId();
        }

        public long getCreationTime() {
            return SessionImpl.this.model == null ? 0L : SessionImpl.this.model.getCreationTime();
        }

        public long getLastAccessedTime() {
            return SessionImpl.this.getLastAccessedTime();
        }

        public int getMaxInactiveInterval() {
            return SessionImpl.this.getMaxInactiveInterval();
        }

        public void setMaxInactiveInterval(int maxInactiveInterval) {
            SessionImpl.this.setMaxInactiveInterval(maxInactiveInterval);
        }

        public ServletContext getServletContext() {
            return SessionImpl.this.getServletContext();
        }

        public Object getAttribute(String name) {
            Object value;
            SessionAttribute attr = (SessionAttribute)SessionImpl.this.attrs.get(name);
            SessionConfig sessionConfig = SessionImpl.this.requestContext.getSessionConfig();
            if (attr == null) {
                String storeName = sessionConfig.getStoreMappings().getStoreNameForAttribute(name);
                if (storeName == null) {
                    value = null;
                } else {
                    attr = new SessionAttribute(name, SessionImpl.this, storeName, new StoreContextImpl(storeName));
                    value = attr.getValue();
                    if (value != null && SessionImpl.this.modelKey.equals(name)) {
                        value = this.decodeSessionModel(value);
                        attr.updateValue(value);
                    }
                    if (value != null) {
                        SessionImpl.this.attrs.put(name, attr);
                    }
                }
            } else {
                value = attr.getValue();
            }
            return this.interceptGet(name, value);
        }

        private Object interceptGet(String name, Object value) {
            for (SessionInterceptor l : SessionImpl.this.getSessionRequestContext().getSessionConfig().getSessionInterceptors()) {
                if (!(l instanceof SessionAttributeInterceptor)) continue;
                SessionAttributeInterceptor interceptor = (SessionAttributeInterceptor)l;
                value = interceptor.onRead(name, value);
            }
            return value;
        }

        private Object decodeSessionModel(Object value) {
            SessionModelEncoder encoder;
            SessionModelEncoder[] encoders;
            SessionModel.Factory factory = new SessionModel.Factory(){

                public SessionModel newInstance(String sessionID, long creationTime, long lastAccessedTime, int maxInactiveInterval) {
                    return new SessionModelImpl(sessionID, creationTime, lastAccessedTime, maxInactiveInterval);
                }
            };
            SessionModel model = null;
            SessionModelEncoder[] arr$ = encoders = SessionImpl.this.requestContext.getSessionConfig().getSessionModelEncoders();
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$ && (model = (encoder = arr$[i$]).decode(value, factory)) == null; ++i$) {
            }
            if (model == null) {
                log.warn("Could not decode session model {} by {} encoders", value, (Object)encoders.length);
            }
            return model;
        }

        public Enumeration<String> getAttributeNames() {
            return SessionImpl.this.getAttributeNames();
        }

        public void setAttribute(String name, Object value) {
            value = this.interceptSet(name, value);
            SessionAttribute attr = (SessionAttribute)SessionImpl.this.attrs.get(name);
            SessionConfig sessionConfig = SessionImpl.this.requestContext.getSessionConfig();
            if (attr == null) {
                String storeName = sessionConfig.getStoreMappings().getStoreNameForAttribute(name);
                if (storeName == null) {
                    throw new IllegalArgumentException("No storage configured for session attribute: " + name);
                }
                attr = new SessionAttribute(name, SessionImpl.this, storeName, new StoreContextImpl(storeName));
                SessionImpl.this.attrs.put(name, attr);
            }
            attr.setValue(value);
        }

        private Object interceptSet(String name, Object value) {
            for (SessionInterceptor l : SessionImpl.this.getSessionRequestContext().getSessionConfig().getSessionInterceptors()) {
                if (!(l instanceof SessionAttributeInterceptor)) continue;
                SessionAttributeInterceptor interceptor = (SessionAttributeInterceptor)l;
                value = interceptor.onWrite(name, value);
            }
            return value;
        }

        public void removeAttribute(String name) {
            SessionImpl.this.removeAttribute(name);
        }

        public void invalidate() {
            SessionConfig sessionConfig = SessionImpl.this.requestContext.getSessionConfig();
            String[] storeNames = sessionConfig.getStores().getStoreNames();
            SessionImpl.this.attrs.clear();
            SessionImpl.this.cleared = true;
            SessionImpl.this.clearingStores.addAll(CollectionUtil.asList(storeNames));
            for (String storeName : storeNames) {
                SessionStore store = sessionConfig.getStores().getStore(storeName);
                store.invaldiate(SessionImpl.this.sessionID, new StoreContextImpl(storeName));
            }
            if (SessionImpl.this.model == null) {
                SessionImpl.this.model = new SessionModelImpl(SessionImpl.this);
            } else {
                SessionImpl.this.model.reset();
            }
        }

        public boolean isNew() {
            return SessionImpl.this.isNew();
        }

        @Deprecated
        public HttpSessionContext getSessionContext() {
            return SessionImpl.this.getSessionContext();
        }

        @Deprecated
        public Object getValue(String name) {
            return SessionImpl.this.getValue(name);
        }

        @Deprecated
        public String[] getValueNames() {
            return SessionImpl.this.getValueNames();
        }

        @Deprecated
        public void putValue(String name, Object value) {
            SessionImpl.this.putValue(name, value);
        }

        @Deprecated
        public void removeValue(String name) {
            SessionImpl.this.removeValue(name);
        }
    }

    private class StoreContextImpl
    implements SessionStore.StoreContext {
        private String storeName;

        public StoreContextImpl(String storeName) {
            this.storeName = storeName;
        }

        public Object getState() {
            return SessionImpl.this.storeStates.get(this.storeName);
        }

        public void setState(Object stateObject) {
            if (stateObject == null) {
                SessionImpl.this.storeStates.remove(this.storeName);
            } else {
                SessionImpl.this.storeStates.put(this.storeName, stateObject);
            }
        }

        public SessionStore.StoreContext getStoreContext(String storeName) {
            return new StoreContextImpl(storeName);
        }

        public SessionRequestContext getSessionRequestContext() {
            return SessionImpl.this.getSessionRequestContext();
        }

        public HttpSession getHttpSession() {
            return SessionImpl.this.sessionInternal;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum EventType {
        CREATED,
        RECREATED,
        INVALIDATED,
        VISITED;

    }

    private static class StoreData {
        private final String storeName;
        private final SessionStore store;
        private final Map<String, Object> attrs = CollectionUtil.createHashMap();

        private StoreData(String storeName, SessionStore store) {
            this.storeName = storeName;
            this.store = store;
        }
    }
}

