/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.service.requestcontext.rewrite.impl;

import com.alibaba.citrus.service.requestcontext.rewrite.RewriteSubstitutionHandler;
import com.alibaba.citrus.service.requestcontext.rewrite.impl.RewriteCondition;
import com.alibaba.citrus.service.requestcontext.rewrite.impl.RewriteSubstitution;
import com.alibaba.citrus.util.ArrayUtil;
import com.alibaba.citrus.util.StringEscapeUtil;
import com.alibaba.citrus.util.StringUtil;
import com.alibaba.citrus.util.ToStringBuilder;
import com.alibaba.citrus.util.regex.MatchResultSubstitution;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;

public class RewriteRule
implements InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(RewriteRule.class);
    private String patternString;
    private Pattern pattern;
    private boolean negative;
    private RewriteCondition[] conditions;
    private RewriteSubstitution substitution;
    private Object[] handlers;

    public String getPattern() {
        return this.patternString;
    }

    public void setPattern(String patternString) throws PatternSyntaxException {
        this.patternString = StringUtil.trimToNull(patternString);
    }

    public void setConditions(RewriteCondition[] conditions) {
        this.conditions = conditions;
    }

    public void setSubstitution(RewriteSubstitution substitution) {
        this.substitution = substitution;
    }

    public void setHandlers(Object[] handlers) {
        this.handlers = handlers;
    }

    public Object[] handlers() {
        return this.handlers;
    }

    public void afterPropertiesSet() throws Exception {
        String realPattern;
        if (this.patternString == null || "!".equals(this.patternString)) {
            throw new PatternSyntaxException("empty pattern", this.patternString, -1);
        }
        if (this.patternString.startsWith("!")) {
            this.negative = true;
            realPattern = this.patternString.substring(1);
        } else {
            realPattern = this.patternString;
        }
        this.pattern = Pattern.compile(realPattern);
        if (this.conditions == null) {
            this.conditions = new RewriteCondition[0];
        }
        if (this.substitution == null) {
            this.substitution = new RewriteSubstitution();
            this.substitution.afterPropertiesSet();
        }
        if (this.handlers == null) {
            this.handlers = new RewriteSubstitutionHandler[0];
        }
    }

    public MatchResult match(String path) {
        Matcher matcher = this.pattern.matcher(path);
        boolean matched = matcher.find();
        if (!this.negative && matched) {
            if (log.isDebugEnabled()) {
                log.debug("Testing \"{}\" with rule pattern: \"{}\", MATCHED", (Object)StringEscapeUtil.escapeJava(path), (Object)StringEscapeUtil.escapeJava(this.patternString));
            }
            return matcher.toMatchResult();
        }
        if (this.negative && !matched) {
            if (log.isDebugEnabled()) {
                log.debug("Testing \"{}\" with rule pattern: \"{}\", MATCHED", (Object)StringEscapeUtil.escapeJava(path), (Object)StringEscapeUtil.escapeJava(this.patternString));
            }
            return MatchResultSubstitution.EMPTY_MATCH_RESULT;
        }
        if (log.isTraceEnabled()) {
            log.trace("Testing \"{}\" with rule pattern: \"{}\", MISMATCHED", (Object)StringEscapeUtil.escapeJava(path), (Object)StringEscapeUtil.escapeJava(this.patternString));
        }
        return null;
    }

    public MatchResult matchConditions(MatchResult ruleMatchResult, HttpServletRequest request) {
        MatchResult conditionMatchResult = MatchResultSubstitution.EMPTY_MATCH_RESULT;
        if (!ArrayUtil.isEmptyArray(this.conditions)) {
            int i = 0;
            for (RewriteCondition condition : this.conditions) {
                boolean ornext;
                MatchResult result = condition.match(ruleMatchResult, conditionMatchResult, request);
                boolean bl = ornext = i < this.conditions.length - 1 && condition.getFlags().hasOR();
                if (result == null) {
                    if (!ornext) {
                        conditionMatchResult = null;
                        break;
                    }
                } else {
                    conditionMatchResult = result;
                    if (ornext) break;
                }
                ++i;
            }
        }
        return conditionMatchResult;
    }

    public RewriteSubstitution getSubstitution() {
        return this.substitution;
    }

    public String toString() {
        ToStringBuilder.MapBuilder mb = new ToStringBuilder.MapBuilder();
        mb.append("pattern", this.patternString);
        if (!ArrayUtil.isEmptyArray(this.conditions)) {
            mb.append("conditions", this.conditions);
        }
        mb.append("substitution", this.substitution);
        return new ToStringBuilder().append("RewriteRule").append(mb).toString();
    }
}

