/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.service.requestcontext.basic.impl;

import com.alibaba.citrus.logconfig.support.SecurityLogger;
import com.alibaba.citrus.service.requestcontext.basic.CookieHeaderValueInterceptor;
import com.alibaba.citrus.service.requestcontext.basic.CookieInterceptor;
import com.alibaba.citrus.service.requestcontext.basic.HeaderNameInterceptor;
import com.alibaba.citrus.service.requestcontext.basic.HeaderValueInterceptor;
import com.alibaba.citrus.service.requestcontext.basic.RedirectLocationInterceptor;
import com.alibaba.citrus.service.requestcontext.basic.RequestContextLifecycleInterceptor;
import com.alibaba.citrus.service.requestcontext.basic.ResponseHeaderRejectedException;
import com.alibaba.citrus.service.requestcontext.basic.StatusMessageInterceptor;
import com.alibaba.citrus.service.requestcontext.util.CookieSupport;
import com.alibaba.citrus.springext.support.parser.AbstractSingleBeanDefinitionParser;
import com.alibaba.citrus.springext.util.SpringExtUtil;
import com.alibaba.citrus.util.HumanReadableSize;
import com.alibaba.citrus.util.ObjectUtil;
import com.alibaba.citrus.util.StringEscapeUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public class ResponseHeaderSecurityFilter
implements RequestContextLifecycleInterceptor,
HeaderNameInterceptor,
HeaderValueInterceptor,
CookieInterceptor,
CookieHeaderValueInterceptor,
StatusMessageInterceptor,
RedirectLocationInterceptor {
    public static final HumanReadableSize MAX_SET_COOKIE_SIZE_DEFAULT = new HumanReadableSize("7k");
    private static final String COOKIE_LENGTH_ATTR = "_COOKIE_LENGTH_";
    private static final Pattern crlf = Pattern.compile("\\r\\n|\\r|\\n");
    private final SecurityLogger log = new SecurityLogger();
    private final CookieLengthAccumulator cookieLengthAccumulator;
    private HumanReadableSize maxSetCookieSize;

    public ResponseHeaderSecurityFilter() {
        this(null);
    }

    public ResponseHeaderSecurityFilter(HttpServletRequest request) {
        SpringExtUtil.assertProxy(request);
        this.cookieLengthAccumulator = request == null ? new ThreadLocalBasedCookieLengthAccumulator() : new RequestBasedCookieLengthAccumulator(request);
    }

    public void setLogName(String logName) {
        this.log.setLogName(logName);
    }

    public HumanReadableSize getMaxSetCookieSize() {
        return this.maxSetCookieSize == null || this.maxSetCookieSize.getValue() <= 0L ? MAX_SET_COOKIE_SIZE_DEFAULT : this.maxSetCookieSize;
    }

    public void setMaxSetCookieSize(HumanReadableSize maxSetCookieSize) {
        this.maxSetCookieSize = maxSetCookieSize;
    }

    public void prepare() {
    }

    public void commitHeaders() {
        this.cookieLengthAccumulator.reset();
    }

    public void commit() {
    }

    public String checkHeaderName(String name) {
        if (this.containsCRLF(name)) {
            String msg = "Invalid response header: " + StringEscapeUtil.escapeJava(name);
            this.log.getLogger().error(msg);
            throw new ResponseHeaderRejectedException(msg);
        }
        return name;
    }

    public String checkHeaderValue(String name, String value) {
        return ObjectUtil.defaultIfNull(this.filterCRLF(value, "header " + name), value);
    }

    public Cookie checkCookie(Cookie cookie) {
        String name = cookie.getName();
        if (this.containsCRLF(name)) {
            this.log.getLogger().error("Invalid cookie name: " + StringEscapeUtil.escapeJava(name));
            return null;
        }
        String value = cookie.getValue();
        String filteredValue = this.filterCRLF(value, "cookie " + name);
        if (filteredValue == null) {
            return cookie;
        }
        CookieSupport newCookie = new CookieSupport(cookie);
        newCookie.setValue(filteredValue);
        return newCookie;
    }

    public String checkCookieHeaderValue(String name, String value, boolean setHeader) {
        if (value != null) {
            int maxSetCookieSize = (int)this.getMaxSetCookieSize().getValue();
            int length = this.cookieLengthAccumulator.getLength();
            if (length + value.length() > maxSetCookieSize) {
                this.log.getLogger().error("Cookie size exceeds the max value: {} + {} > maxSize {}.  Cookie is ignored: {}", new Object[]{length, value.length(), this.getMaxSetCookieSize(), value});
                return "";
            }
            if (setHeader) {
                this.cookieLengthAccumulator.setCookie(value);
            } else {
                this.cookieLengthAccumulator.addCookie(value);
            }
        }
        return value;
    }

    public String checkStatusMessage(int sc, String msg) {
        return StringEscapeUtil.escapeHtml(msg);
    }

    public String checkRedirectLocation(String location) {
        return ObjectUtil.defaultIfNull(this.filterCRLF(location, "redirectLocation"), location);
    }

    private boolean containsCRLF(String str) {
        if (str != null) {
            for (int i = 0; i < str.length(); ++i) {
                switch (str.charAt(i)) {
                    case '\n': 
                    case '\r': {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private String filterCRLF(String value, String logInfo) {
        if (this.containsCRLF(value)) {
            this.log.getLogger().warn("Found CRLF in {}: {}", (Object)logInfo, (Object)StringEscapeUtil.escapeJava(value));
            StringBuffer sb = new StringBuffer();
            Matcher m = crlf.matcher(value);
            while (m.find()) {
                m.appendReplacement(sb, " ");
            }
            m.appendTail(sb);
            return sb.toString();
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DefinitionParser
    extends AbstractSingleBeanDefinitionParser<ResponseHeaderSecurityFilter> {
        protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
            SpringExtUtil.attributesToProperties(element, builder, "logName", "maxSetCookieSize");
            SpringExtUtil.addConstructorArg(builder, true, HttpServletRequest.class);
        }
    }

    private final class RequestBasedCookieLengthAccumulator
    extends CookieLengthAccumulator {
        private final HttpServletRequest request;

        private RequestBasedCookieLengthAccumulator(HttpServletRequest request) {
            this.request = request;
        }

        public int getLength() {
            Object value = this.request.getAttribute(ResponseHeaderSecurityFilter.COOKIE_LENGTH_ATTR);
            if (value instanceof Integer) {
                return (Integer)value;
            }
            return 0;
        }

        protected void setLength(int length) {
            this.request.setAttribute(ResponseHeaderSecurityFilter.COOKIE_LENGTH_ATTR, (Object)length);
        }

        protected void reset() {
            this.request.removeAttribute(ResponseHeaderSecurityFilter.COOKIE_LENGTH_ATTR);
        }
    }

    private final class ThreadLocalBasedCookieLengthAccumulator
    extends CookieLengthAccumulator {
        private final ThreadLocal<Integer> cookieLengthHolder;

        private ThreadLocalBasedCookieLengthAccumulator() {
            this.cookieLengthHolder = new ThreadLocal();
        }

        public int getLength() {
            Integer value = this.cookieLengthHolder.get();
            if (value instanceof Integer) {
                return value;
            }
            return 0;
        }

        protected void setLength(int length) {
            this.cookieLengthHolder.set(length);
        }

        protected void reset() {
            this.cookieLengthHolder.remove();
        }
    }

    private static abstract class CookieLengthAccumulator {
        private CookieLengthAccumulator() {
        }

        public final void addCookie(String cookie) {
            this.setLength(this.getLength() + cookie.length());
        }

        public final void setCookie(String cookie) {
            this.setLength(cookie.length());
        }

        public abstract int getLength();

        protected abstract void setLength(int var1);

        protected abstract void reset();
    }
}

