/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.service.pipeline.impl.condition;

import com.alibaba.citrus.expr.Expression;
import com.alibaba.citrus.expr.ExpressionContext;
import com.alibaba.citrus.expr.ExpressionFactory;
import com.alibaba.citrus.expr.ExpressionParseException;
import com.alibaba.citrus.expr.jexl.JexlExpressionFactory;
import com.alibaba.citrus.service.pipeline.PipelineException;
import com.alibaba.citrus.service.pipeline.PipelineStates;
import com.alibaba.citrus.service.pipeline.support.AbstractCondition;
import com.alibaba.citrus.service.pipeline.support.AbstractConditionDefinitionParser;
import com.alibaba.citrus.util.Assert;
import com.alibaba.citrus.util.StringEscapeUtil;
import com.alibaba.citrus.util.StringUtil;
import org.springframework.beans.SimpleTypeConverter;
import org.springframework.beans.TypeMismatchException;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public class JexlCondition
extends AbstractCondition {
    protected static final ExpressionFactory EXPRESSION_FACTORY = new JexlExpressionFactory();
    private String expressionString;
    private Expression expression;

    public JexlCondition() {
    }

    public JexlCondition(String expr) {
        this.setExpression(expr);
    }

    public String getExpression() {
        return this.expressionString;
    }

    public void setExpression(String expr) {
        expr = Assert.assertNotNull(StringUtil.trimToNull(expr), "missing condition expression", new Object[0]);
        try {
            this.expression = EXPRESSION_FACTORY.createExpression(expr);
        }
        catch (ExpressionParseException e) {
            throw new IllegalArgumentException("Invalid expression: \"" + this.getEscapedExpression(expr) + "\"", e);
        }
        this.expressionString = expr;
    }

    protected void init() {
        Assert.assertNotNull(this.expression, "no expression", new Object[0]);
    }

    public boolean isSatisfied(PipelineStates pipelineStates) {
        Assert.assertNotNull(this.expression, "no expression", new Object[0]);
        PipelineExpressionContext expressionContext = new PipelineExpressionContext(pipelineStates);
        Object value = this.expression.evaluate(expressionContext);
        if (value == null) {
            return false;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        try {
            return (Boolean)new SimpleTypeConverter().convertIfNecessary(value, Boolean.class);
        }
        catch (TypeMismatchException e) {
            throw new PipelineException("Failed to evaluating expression for JexlCondition into a boolean value: \"" + this.getEscapedExpression(this.expressionString) + "\"", e);
        }
    }

    public String toString() {
        return "JexlCondition[" + this.getEscapedExpression(this.expressionString) + "]";
    }

    private String getEscapedExpression(String expr) {
        return StringEscapeUtil.escapeJava(expr);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DefinitionParser
    extends AbstractConditionDefinitionParser<JexlCondition> {
        @Override
        protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
            super.doParse(element, parserContext, builder);
            builder.addPropertyValue("expression", (Object)element.getAttribute("expr"));
        }
    }

    private static class PipelineExpressionContext
    implements ExpressionContext {
        private final PipelineStates pipelineStates;

        public PipelineExpressionContext(PipelineStates pipelineStates) {
            this.pipelineStates = pipelineStates;
        }

        public Object get(String key) {
            return this.pipelineStates.getAttribute(key);
        }

        public void put(String key, Object value) {
            this.pipelineStates.setAttribute(key, value);
        }
    }
}

