/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.service.moduleloader.impl.adapter;

import com.alibaba.citrus.service.moduleloader.ModuleEvent;
import com.alibaba.citrus.service.moduleloader.ModuleEventException;
import com.alibaba.citrus.service.moduleloader.ModuleEventNotFoundException;
import com.alibaba.citrus.service.moduleloader.impl.adapter.AbstractDataBindingAdapter;
import com.alibaba.citrus.service.moduleloader.impl.adapter.MethodInvoker;
import com.alibaba.citrus.springext.util.SpringExtUtil;
import com.alibaba.citrus.util.Assert;
import com.alibaba.citrus.util.ToStringBuilder;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractModuleEventAdapter
extends AbstractDataBindingAdapter
implements InitializingBean,
ModuleEvent {
    private final Map<String, MethodInvoker> handlers;
    private final MethodInvoker preHandler;
    private final MethodInvoker postHandler;
    @Autowired
    private HttpServletRequest request;

    protected AbstractModuleEventAdapter(Object moduleObject, Map<String, MethodInvoker> handlers, MethodInvoker preHandler, MethodInvoker postHandler) {
        super(moduleObject);
        this.handlers = Assert.assertNotNull(handlers, "handlers", new Object[0]);
        this.preHandler = preHandler;
        this.postHandler = postHandler;
        Assert.assertTrue(!handlers.isEmpty(), "handlers", new Object[0]);
    }

    public void afterPropertiesSet() {
        SpringExtUtil.assertProxy(Assert.assertNotNull(this.request, "missing HttpServletRequest object", new Object[0]));
    }

    @Override
    public void execute() throws ModuleEventException, ModuleEventNotFoundException {
        this.executeAndReturn();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object executeAndReturn() throws ModuleEventException, ModuleEventNotFoundException {
        Object result = null;
        String event = this.getEventName(this.request);
        MethodInvoker handler = null;
        if (event != null) {
            handler = this.handlers.get(event);
        }
        if (handler == null) {
            handler = this.handlers.get(null);
        }
        if (handler == null) {
            throw new ModuleEventNotFoundException("Could not find handler method for event: " + event);
        }
        if (this.preHandler != null) {
            this.log.debug("Invoking pre-handler for event {}: {}", (Object)event, (Object)this.preHandler);
            try {
                this.preHandler.invoke(this.moduleObject, this.log);
            }
            catch (Exception e) {
                throw new ModuleEventException("Failed to execute pre-handler: " + this.preHandler, e);
            }
        }
        ModuleEventException exception = null;
        try {
            this.log.debug("Invoking handler for event {}: {}", (Object)event, (Object)handler);
            try {
                result = handler.invoke(this.moduleObject, this.log);
            }
            catch (Exception e) {
                exception = new ModuleEventException("Failed to execute handler: " + handler, e);
            }
        }
        finally {
            block18: {
                if (this.postHandler != null) {
                    this.log.debug("Invoking post-handler for event {}: {}", (Object)event, (Object)this.postHandler);
                    try {
                        this.postHandler.invoke(this.moduleObject, this.log);
                    }
                    catch (Exception e) {
                        if (exception != null) break block18;
                        exception = new ModuleEventException("Failed to execute post-handler: " + this.postHandler, e);
                    }
                }
            }
        }
        if (exception != null) {
            throw exception;
        }
        return result;
    }

    protected abstract String getEventName(HttpServletRequest var1);

    public String toString() {
        ToStringBuilder.MapBuilder mb = new ToStringBuilder.MapBuilder();
        mb.append("moduleClass", this.moduleObject.getClass().getName());
        mb.append("handlers", new ToStringBuilder.MapBuilder().appendAll(this.handlers).setPrintCount(true).setSortKeys(true));
        mb.append("preHandler", this.preHandler);
        mb.append("postHandler", this.postHandler);
        return new ToStringBuilder().append(this.getClass().getSimpleName()).append(mb).toString();
    }
}

