/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.service.mail.impl;

import com.alibaba.citrus.service.mail.builder.MailAddressType;
import com.alibaba.citrus.service.mail.impl.MailBuilderFactory;
import com.alibaba.citrus.service.mail.impl.MailServiceImpl;
import com.alibaba.citrus.service.mail.session.MailStore;
import com.alibaba.citrus.service.mail.session.MailTransport;
import com.alibaba.citrus.springext.ConfigurationPoint;
import com.alibaba.citrus.springext.Contribution;
import com.alibaba.citrus.springext.ContributionAware;
import com.alibaba.citrus.springext.support.parser.AbstractNamedBeanDefinitionParser;
import com.alibaba.citrus.springext.util.DomUtil;
import com.alibaba.citrus.springext.util.SpringExtUtil;
import com.alibaba.citrus.util.Assert;
import com.alibaba.citrus.util.StringUtil;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MailServiceDefinitionParser
extends AbstractNamedBeanDefinitionParser<MailServiceImpl>
implements ContributionAware {
    private ConfigurationPoint contentsConfigurationPoint;

    @Override
    public void setContribution(Contribution contrib) {
        this.contentsConfigurationPoint = SpringExtUtil.getSiblingConfigurationPoint("services/mails/contents", contrib);
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        SpringExtUtil.parseBeanDefinitionAttributes(element, parserContext, builder);
        Element defaultSettingsElement = DomUtil.theOnlySubElement(element, DomUtil.and(DomUtil.sameNs(element), DomUtil.name("default-settings")));
        if (defaultSettingsElement != null) {
            this.parseDefaultSettings(defaultSettingsElement, parserContext, builder);
        }
        DomUtil.ElementSelector mailSelector = DomUtil.and(DomUtil.sameNs(element), DomUtil.name("mail"));
        DomUtil.ElementSelector storeSelector = DomUtil.and(DomUtil.sameNs(element), DomUtil.name("mail-store"));
        DomUtil.ElementSelector transportSelector = DomUtil.and(DomUtil.sameNs(element), DomUtil.name("mail-transport"));
        Map<Object, Object> mails = SpringExtUtil.createManagedMap(element, parserContext);
        Map<Object, Object> mailStores = SpringExtUtil.createManagedMap(element, parserContext);
        Map<Object, Object> mailTransports = SpringExtUtil.createManagedMap(element, parserContext);
        for (Element subElement : DomUtil.subElements(element)) {
            Map<Object, Object> container;
            BeanDefinitionHolder holder;
            if (mailSelector.accept(subElement)) {
                holder = this.parseMail(subElement, parserContext, builder.getRawBeanDefinition());
                container = mails;
            } else if (storeSelector.accept(subElement)) {
                holder = this.parseMailStore(subElement, parserContext, builder.getRawBeanDefinition());
                container = mailStores;
            } else {
                if (!transportSelector.accept(subElement)) continue;
                holder = this.parseMailTransport(subElement, parserContext, builder.getRawBeanDefinition());
                container = mailTransports;
            }
            container.put(holder.getBeanName(), holder);
        }
        builder.addPropertyValue("mails", mails);
        builder.addPropertyValue("mailStores", mailStores);
        builder.addPropertyValue("mailTransports", mailTransports);
    }

    private void parseDefaultSettings(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        List<Object> importedServices = SpringExtUtil.createManagedList(element, parserContext);
        for (Element subElement : DomUtil.subElements(element, DomUtil.and(DomUtil.sameNs(element), DomUtil.name("import")))) {
            String serviceRef = Assert.assertNotNull(StringUtil.trimToNull(subElement.getAttribute("serviceRef")), "miss serviceRef", new Object[0]);
            importedServices.add(new RuntimeBeanReference(serviceRef));
        }
        builder.addPropertyValue("importedServices", importedServices);
    }

    private BeanDefinitionHolder parseMail(Element element, ParserContext parserContext, AbstractBeanDefinition containingBean) {
        Element contentElement;
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(MailBuilderFactory.class);
        builder.addPropertyValue("charset", (Object)element.getAttribute("charset"));
        Map<Object, Object> addrs = SpringExtUtil.createManagedMap(element, parserContext);
        for (MailAddressType addrType : MailAddressType.values()) {
            addrs.put(addrType.name(), this.getAddresses(element, parserContext, DomUtil.and(DomUtil.sameNs(element), DomUtil.name(addrType.getTagName()))));
        }
        builder.addPropertyValue("addresses", addrs);
        Element subjectElement = DomUtil.theOnlySubElement(element, DomUtil.and(DomUtil.sameNs(element), DomUtil.name("subject")));
        if (subjectElement != null) {
            builder.addPropertyValue("subject", (Object)subjectElement.getTextContent());
        }
        if ((contentElement = DomUtil.theOnlySubElement(element, DomUtil.ns(this.contentsConfigurationPoint.getNamespaceUri()))) != null) {
            builder.addPropertyValue("content", (Object)SpringExtUtil.parseConfigurationPointBean(contentElement, this.contentsConfigurationPoint, parserContext, builder));
        }
        return this.getBeanDefinitionHolder(element, builder);
    }

    private List<Object> getAddresses(Element element, ParserContext parserContext, DomUtil.ElementSelector selector) {
        List<Object> addrs = SpringExtUtil.createManagedList(element, parserContext);
        for (Element subElement : DomUtil.subElements(element, selector)) {
            addrs.add(subElement.getTextContent());
        }
        return addrs;
    }

    private BeanDefinitionHolder parseMailStore(Element element, ParserContext parserContext, AbstractBeanDefinition containingBean) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(MailStore.class);
        SpringExtUtil.attributesToProperties(element, builder, "protocol", "folder");
        this.parseMailSession(element, parserContext, builder);
        return this.getBeanDefinitionHolder(element, builder);
    }

    private BeanDefinitionHolder parseMailTransport(Element element, ParserContext parserContext, AbstractBeanDefinition containingBean) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(MailTransport.class);
        SpringExtUtil.attributesToProperties(element, builder, "protocol", "popBeforeSmtp");
        this.parseMailSession(element, parserContext, builder);
        return this.getBeanDefinitionHolder(element, builder);
    }

    private void parseMailSession(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        SpringExtUtil.attributesToProperties(element, builder, "host", "port", "user", "password", "debug", "default");
        Map<Object, Object> props = SpringExtUtil.createManagedMap(element, parserContext);
        for (Element subElement : DomUtil.subElements(element, DomUtil.and(DomUtil.sameNs(element), DomUtil.name("property")))) {
            String name = StringUtil.trimToNull(subElement.getAttribute("name"));
            String value = StringUtil.trimToNull(subElement.getAttribute("value"));
            if (value == null) {
                value = StringUtil.trimToNull(subElement.getTextContent());
            }
            props.put(name, value);
        }
        builder.addPropertyValue("properties", props);
    }

    private BeanDefinitionHolder getBeanDefinitionHolder(Element element, BeanDefinitionBuilder builder) {
        return new BeanDefinitionHolder((BeanDefinition)builder.getBeanDefinition(), StringUtil.trimToNull(element.getAttribute("id")));
    }

    @Override
    protected String getDefaultName() {
        return "mails, mailService";
    }
}

