/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.service.mail.builder.content;

import com.alibaba.citrus.service.mail.builder.content.AbstractContent;
import com.alibaba.citrus.service.mail.util.MailUtil;
import com.alibaba.citrus.util.ObjectUtil;
import com.alibaba.citrus.util.StringUtil;
import com.alibaba.citrus.util.ToStringBuilder;
import javax.mail.MessagingException;
import javax.mail.Part;
import javax.mail.internet.ContentType;

public class TextContent
extends AbstractContent {
    private String text;
    private String contentType;

    public TextContent() {
    }

    public TextContent(String text) {
        this.setText(text);
    }

    public TextContent(String text, String contentType) {
        this.setText(text);
        this.setContentType(contentType);
    }

    public String getText() {
        return ObjectUtil.defaultIfNull(this.text, "");
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getContentType() {
        return ObjectUtil.defaultIfNull(this.contentType, "text/plain");
    }

    public void setContentType(String contentType) {
        this.contentType = StringUtil.trimToNull(contentType);
    }

    public void render(Part mailPart) throws MessagingException {
        String text = this.getText();
        String contentType = this.getContentType();
        ContentType contentTypeObject = MailUtil.getContentType(contentType, this.getMailBuilder().getCharacterEncoding());
        mailPart.setContent((Object)text, contentTypeObject.toString());
        mailPart.setHeader("Content-Transfer-Encoding", "8bit");
    }

    protected TextContent newInstance() {
        return new TextContent(this.text, this.contentType);
    }

    protected void toString(ToStringBuilder.MapBuilder mb) {
        mb.append("contentType", this.getContentType());
        mb.append("text", this.text);
    }
}

