/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.service.jsp.impl;

import com.alibaba.citrus.service.template.TemplateContext;
import com.alibaba.citrus.util.Assert;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateContextAdapter
extends HttpServletRequestWrapper {
    private final TemplateContext context;

    public TemplateContextAdapter(HttpServletRequest request, TemplateContext context) {
        super(Assert.assertNotNull(request, "request", new Object[0]));
        this.context = Assert.assertNotNull(context, "templateContext", new Object[0]);
    }

    public TemplateContext getTemplateContext() {
        return this.context;
    }

    public Enumeration<String> getAttributeNames() {
        Enumeration attrNames = this.getRequest().getAttributeNames();
        return new AttributeNamesEnumeration(this.context.keySet(), attrNames);
    }

    public Object getAttribute(String name) {
        Object value = this.context.get(name);
        if (value == null) {
            value = this.getRequest().getAttribute(name);
        }
        return value;
    }

    public void setAttribute(String name, Object value) {
        this.context.remove(name);
        this.getRequest().setAttribute(name, value);
    }

    public void removeAttribute(String name) {
        this.context.remove(name);
        this.getRequest().removeAttribute(name);
    }

    public String toString() {
        return "TemplateContextAdapter[" + this.context + "]";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AttributeNamesEnumeration
    implements Enumeration<String> {
        private final Set<String> set;
        private final Iterator<String> iterator;
        private final Enumeration<String> enumeration;
        private String next = null;

        public AttributeNamesEnumeration(Set<String> set, Enumeration<String> enumeration) {
            this.set = set;
            this.iterator = set.iterator();
            this.enumeration = enumeration;
        }

        @Override
        public boolean hasMoreElements() {
            if (this.next == null) {
                if (this.iterator.hasNext()) {
                    this.next = this.iterator.next();
                } else if (this.enumeration != null) {
                    while (this.next == null && this.enumeration.hasMoreElements()) {
                        this.next = this.enumeration.nextElement();
                        if (!this.set.contains(this.next)) continue;
                        this.next = null;
                    }
                }
            }
            return this.next != null;
        }

        @Override
        public String nextElement() {
            if (this.hasMoreElements()) {
                String result = this.next;
                this.next = null;
                return result;
            }
            throw new NoSuchElementException();
        }
    }
}

