/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.service.freemarker.impl;

import com.alibaba.citrus.util.Assert;
import com.alibaba.citrus.util.FileUtil;
import com.alibaba.citrus.util.StringUtil;
import freemarker.cache.TemplateLoader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;

public class SpringResourceLoaderAdapter
implements TemplateLoader {
    private final ResourceLoader springLoader;
    private final String path;

    public SpringResourceLoaderAdapter(ResourceLoader springLoader, String path) {
        this.springLoader = Assert.assertNotNull(springLoader, "spring resource loader", new Object[0]);
        path = FileUtil.normalizeAbsolutePath(path, true);
        Assert.assertTrue(!StringUtil.isEmpty(path), "path", new Object[0]);
        this.path = path + '/';
    }

    public String getPath() {
        return this.path;
    }

    public Object findTemplateSource(String templateName) {
        Resource resource = this.springLoader.getResource(this.path + this.normalizeTemplateName(templateName));
        if (resource == null || !resource.exists()) {
            return null;
        }
        return new TemplateSource(resource);
    }

    public long getLastModified(Object templateSource) {
        long lastModified;
        try {
            lastModified = this.getTemplateSource(templateSource).getResource().lastModified();
            if (lastModified <= 0L) {
                lastModified = -1L;
            }
        }
        catch (IOException e) {
            lastModified = -1L;
        }
        return lastModified;
    }

    public Reader getReader(Object templateSource, String charset) throws IOException {
        return new InputStreamReader(this.getTemplateSource(templateSource).getInputStream(), charset);
    }

    public void closeTemplateSource(Object templateSource) throws IOException {
        this.getTemplateSource(templateSource).close();
    }

    private TemplateSource getTemplateSource(Object templateSource) {
        return (TemplateSource)Assert.assertNotNull(templateSource, "templateSource", new Object[0]);
    }

    private String normalizeTemplateName(String templateName) {
        if ((templateName = Assert.assertNotNull(StringUtil.trimToNull(templateName), "templateName", new Object[0])).startsWith("/")) {
            templateName = templateName.substring(1);
        }
        return templateName;
    }

    public static class TemplateSource {
        private final Resource resource;
        private InputStream istream;

        public TemplateSource(Resource resource) {
            this.resource = Assert.assertNotNull(resource, "resource", new Object[0]);
        }

        public Resource getResource() {
            return this.resource;
        }

        public InputStream getInputStream() throws IOException {
            if (this.istream == null) {
                this.istream = this.resource.getInputStream();
            }
            return this.istream;
        }

        public void close() {
            if (this.istream != null) {
                try {
                    this.istream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.istream = null;
            }
        }

        public int hashCode() {
            return 31 + (this.resource == null ? 0 : this.resource.hashCode());
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TemplateSource other = (TemplateSource)obj;
            return !(this.resource == null ? other.resource != null : !this.resource.equals(other.resource));
        }

        public String toString() {
            return this.resource.toString();
        }
    }
}

