/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.service.form.support;

import com.alibaba.citrus.util.Assert;
import com.alibaba.citrus.util.ObjectUtil;
import com.alibaba.citrus.util.StringUtil;
import java.beans.PropertyEditorSupport;
import java.math.BigDecimal;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NumberSupport
implements Comparable<NumberSupport> {
    private String stringValue;
    private Number numberValue;
    private Type numberType;

    public NumberSupport() {
    }

    public NumberSupport(Type numberType, String stringValue) {
        this.setNumberType(numberType);
        this.setStringValue(stringValue);
    }

    public String getStringValue() {
        return this.stringValue;
    }

    public void setStringValue(String stringValue) {
        this.stringValue = StringUtil.trimToNull(stringValue);
    }

    public Type getNumberType() {
        return this.numberType;
    }

    public void setNumberType(Type numberType) {
        this.numberType = numberType;
    }

    public Number getValue() throws NumberFormatException, IllegalArgumentException {
        Assert.assertNotNull(this.numberType, "no number type specified", new Object[0]);
        Assert.assertNotNull(this.stringValue, "no value set", new Object[0]);
        if (this.numberValue == null) {
            this.numberValue = this.numberType.parse(this.stringValue);
        }
        return this.numberValue;
    }

    @Override
    public int compareTo(NumberSupport n) {
        Number v1 = this.getValue();
        Number v2 = n.getValue();
        Assert.assertTrue(v1 instanceof Comparable, "not comparable number: %s", v1);
        return ((Comparable)((Object)v1)).compareTo(v2);
    }

    public int hashCode() {
        return 31 + this.getValue().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (obj instanceof NumberSupport && this.getNumberType() == ((NumberSupport)obj).getNumberType()) {
            return this.compareTo((NumberSupport)obj) == 0;
        }
        return false;
    }

    public String toString() {
        return this.numberValue == null ? this.stringValue : this.numberValue.toString();
    }

    public static class TypeEditor
    extends PropertyEditorSupport {
        public void setAsText(String text) throws IllegalArgumentException {
            this.setValue((Object)Type.byName(text));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        INT{

            public Number parse(String value) {
                return Integer.parseInt(value);
            }
        }
        ,
        LONG{

            public Number parse(String value) {
                return Long.parseLong(value);
            }
        }
        ,
        FLOAT{

            public Number parse(String value) {
                return Float.valueOf(Float.parseFloat(value));
            }
        }
        ,
        DOUBLE{

            public Number parse(String value) {
                return Double.parseDouble(value);
            }
        }
        ,
        BIG_DECIMAL{

            public Number parse(String value) {
                if (value == null || !numberPattern.matcher(value).matches()) {
                    throw new NumberFormatException(value);
                }
                return new BigDecimal(value);
            }
        };

        private static final Pattern numberPattern;

        public static Type byName(String name) {
            name = ObjectUtil.defaultIfNull(StringUtil.trimToNull(name), "INT");
            String typeName = StringUtil.toUpperCaseWithUnderscores(name);
            try {
                return Type.valueOf(typeName);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("wrong number type: " + name);
            }
        }

        public abstract Number parse(String var1) throws NumberFormatException;

        static {
            numberPattern = Pattern.compile("(\\+|-)?[\\d\\.]+");
        }
    }
}

