/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.service.form.impl.configuration;

import com.alibaba.citrus.service.form.Validator;
import com.alibaba.citrus.service.form.configuration.FieldConfig;
import com.alibaba.citrus.service.form.configuration.FormConfig;
import com.alibaba.citrus.service.form.configuration.GroupConfig;
import com.alibaba.citrus.service.form.impl.configuration.AbstractConfig;
import com.alibaba.citrus.service.form.impl.configuration.FieldConfigImpl;
import com.alibaba.citrus.util.Assert;
import com.alibaba.citrus.util.CollectionUtil;
import com.alibaba.citrus.util.StringUtil;
import java.util.Collections;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupConfigImpl
extends AbstractConfig<GroupConfig>
implements GroupConfig {
    private FormConfig formConfig;
    private String parentGroup;
    private String name;
    private String key;
    private Map<String, FieldConfigImpl> fields;
    private Map<String, FieldConfigImpl> fieldsByKey;
    private List<GroupConfig.Import> imports;
    private List<GroupConfig.Import> importList;
    private List<FieldConfig> fieldList;
    private Boolean trimmingByDefault;
    private Boolean postOnly;

    @Override
    public FormConfig getFormConfig() {
        return this.formConfig;
    }

    public void setFormConfig(FormConfig formConfig) {
        this.formConfig = formConfig;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = StringUtil.trimToNull(name);
    }

    @Override
    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = StringUtil.trimToNull(key);
    }

    @Override
    public String getParentGroup() {
        return this.parentGroup;
    }

    public void setParentGroup(String parentGroup) {
        this.parentGroup = StringUtil.trimToNull(parentGroup);
    }

    @Override
    public boolean isTrimmingByDefault() {
        return this.trimmingByDefault == null ? true : this.trimmingByDefault;
    }

    public void setTrimmingByDefault(boolean trimmingByDefault) {
        this.trimmingByDefault = trimmingByDefault;
    }

    @Override
    public boolean isPostOnly() {
        if (this.postOnly == null) {
            return this.formConfig == null ? true : this.formConfig.isPostOnlyByDefault();
        }
        return this.postOnly;
    }

    public void setPostOnly(boolean postOnly) {
        this.postOnly = postOnly;
    }

    @Override
    public List<FieldConfig> getFieldConfigList() {
        if (this.fieldList == null) {
            return Collections.emptyList();
        }
        return this.fieldList;
    }

    @Override
    public FieldConfig getFieldConfig(String fieldName) {
        if (this.fields == null) {
            return null;
        }
        return this.fields.get(this.caseInsensitiveName(fieldName));
    }

    @Override
    public FieldConfig getFieldConfigByKey(String fieldKey) {
        return Assert.assertNotNull(this.fieldsByKey, Assert.ExceptionType.ILLEGAL_STATE, "fieldsByKey not inited", new Object[0]).get(fieldKey);
    }

    public void setFieldConfigImplList(List<FieldConfigImpl> fieldConfigList) {
        if (fieldConfigList != null) {
            this.fields = CollectionUtil.createLinkedHashMap();
            for (FieldConfigImpl fieldConfig : fieldConfigList) {
                this.addFieldConfig(fieldConfig, true);
            }
        }
    }

    private void addFieldConfig(FieldConfigImpl fieldConfig, boolean checkDuplicate) {
        if (this.fields == null) {
            this.fields = CollectionUtil.createLinkedHashMap();
        }
        String fieldName = this.caseInsensitiveName(fieldConfig.getName());
        if (checkDuplicate) {
            Assert.assertTrue(!this.fields.containsKey(fieldName), "Duplicated field name: \"%s.%s\"", this.getName(), fieldConfig.getName());
        }
        this.fields.put(fieldName, fieldConfig);
    }

    @Override
    public List<GroupConfig.Import> getImports() {
        if (this.importList == null) {
            return Collections.emptyList();
        }
        return this.importList;
    }

    public void setImports(List<GroupConfig.Import> imports) {
        if (imports != null) {
            this.imports = CollectionUtil.createArrayList(imports);
            this.importList = Collections.unmodifiableList(this.imports);
        }
    }

    void extendsFrom(GroupConfigImpl parentGroupConfig) {
        if (this.trimmingByDefault == null && parentGroupConfig.trimmingByDefault != null) {
            this.trimmingByDefault = parentGroupConfig.trimmingByDefault;
        }
        if (this.postOnly == null && parentGroupConfig.postOnly != null) {
            this.postOnly = parentGroupConfig.postOnly;
        }
        this.extendsOrImports(parentGroupConfig, null, false);
    }

    void importsFrom(GroupConfigImpl srcGroupConfig, String fieldName) {
        this.extendsOrImports(srcGroupConfig, fieldName, true);
    }

    private void extendsOrImports(GroupConfigImpl srcGroupConfig, String fieldName, boolean checkDuplicate) {
        if (fieldName == null) {
            for (FieldConfig srcFieldConfig : srcGroupConfig.getFieldConfigList()) {
                this.mergeField((FieldConfigImpl)srcFieldConfig, checkDuplicate);
            }
        } else {
            FieldConfig srcFieldConfig = srcGroupConfig.getFieldConfig(fieldName);
            Assert.assertNotNull(srcFieldConfig, "Field \"%s.%s\" not found", srcGroupConfig.getName(), fieldName);
            this.mergeField((FieldConfigImpl)srcFieldConfig, checkDuplicate);
        }
    }

    private void mergeField(FieldConfigImpl srcFieldConfig, boolean checkDuplicate) {
        FieldConfigImpl copy = (FieldConfigImpl)this.getFieldConfig(srcFieldConfig.getName());
        if (copy == null) {
            copy = new FieldConfigImpl();
            copy.setGroupConfig(this);
        }
        copy.mergeWith(srcFieldConfig);
        this.addFieldConfig(copy, checkDuplicate);
    }

    void init2() throws Exception {
        Assert.assertNotNull(this.fields, "no fields", new Object[0]);
        this.fieldsByKey = CollectionUtil.createHashMap();
        this.fieldList = CollectionUtil.createArrayList(this.fields.size());
        for (Map.Entry<String, FieldConfigImpl> entry : this.fields.entrySet()) {
            String caseInsensitiveName = entry.getKey();
            FieldConfigImpl fieldConfig = entry.getValue();
            block0 : switch (this.getFormConfig().getFieldKeyFormat()) {
                case uncompressed: {
                    fieldConfig.setKey(caseInsensitiveName);
                    break;
                }
                default: {
                    for (int i = 1; i <= caseInsensitiveName.length(); ++i) {
                        String key = caseInsensitiveName.substring(0, i);
                        if (this.fieldsByKey.containsKey(key)) continue;
                        fieldConfig.setKey(key);
                        this.fieldsByKey.put(key, fieldConfig);
                        break block0;
                    }
                }
            }
            this.fieldsByKey.put(caseInsensitiveName, fieldConfig);
            fieldConfig.setGroupConfig(this);
            this.fieldList.add(fieldConfig);
        }
        this.fieldList = Collections.unmodifiableList(this.fieldList);
        for (FieldConfig fieldConfig : this.fieldList) {
            for (Validator validator : fieldConfig.getValidators()) {
                validator.init(fieldConfig);
            }
        }
    }

    @Override
    public String toString() {
        return "GroupConfig[name: " + this.getName() + ", fields: " + this.getFieldConfigList().size() + "]";
    }

    public static final class ImportImpl
    implements GroupConfig.Import {
        private final String groupName;
        private final String fieldName;

        public ImportImpl(String groupName, String fieldName) {
            this.groupName = StringUtil.trimToNull(groupName);
            this.fieldName = StringUtil.trimToNull(fieldName);
        }

        public String getGroupName() {
            return this.groupName;
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public String toString() {
            return this.fieldName == null ? this.groupName : this.groupName + "." + this.fieldName;
        }
    }
}

