/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.service.dataresolver.impl;

import com.alibaba.citrus.service.AbstractService;
import com.alibaba.citrus.service.dataresolver.DataResolver;
import com.alibaba.citrus.service.dataresolver.DataResolverContext;
import com.alibaba.citrus.service.dataresolver.DataResolverFactory;
import com.alibaba.citrus.service.dataresolver.DataResolverNotFoundException;
import com.alibaba.citrus.service.dataresolver.DataResolverService;
import com.alibaba.citrus.util.ArrayUtil;
import com.alibaba.citrus.util.Assert;
import com.alibaba.citrus.util.ToStringBuilder;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import org.springframework.core.MethodParameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataResolverServiceImpl
extends AbstractService<DataResolverService>
implements DataResolverService {
    private DataResolverFactory[] factories;

    public void setFactories(DataResolverFactory[] factories) {
        this.factories = factories;
    }

    @Override
    protected void init() throws Exception {
        if (this.factories == null) {
            this.factories = new DataResolverFactory[0];
        }
    }

    @Override
    public DataResolver getDataResolver(Type type, Annotation[] annotations, Object ... extraInfo) throws DataResolverNotFoundException {
        DataResolverContext context = new DataResolverContext(type, annotations, extraInfo);
        DataResolver resolver = null;
        for (DataResolverFactory factory : this.factories) {
            resolver = factory.getDataResolver(context);
            if (resolver == null) continue;
            this.getLogger().debug("Found resolver: {}", (Object)resolver);
            break;
        }
        if (resolver == null) {
            throw new DataResolverNotFoundException("Could not find data resolver for " + context);
        }
        return resolver;
    }

    @Override
    public DataResolver[] getParameterResolvers(Method method, Object ... extraInfo) throws DataResolverNotFoundException {
        Assert.assertNotNull(method, "method", new Object[0]);
        Method annotatedMethod = this.getAnnotatedMethod(method);
        Type[] paramTypes = annotatedMethod.getGenericParameterTypes();
        Annotation[][] paramAnnotations = annotatedMethod.getParameterAnnotations();
        Assert.assertTrue(paramTypes.length == paramAnnotations.length, "invalid params", new Object[0]);
        DataResolver[] resolvers = new DataResolver[paramTypes.length];
        for (int i = 0; i < paramTypes.length; ++i) {
            Type type = Assert.assertNotNull(paramTypes[i], "paramTypes", new Object[0]);
            Annotation[] annotations = Assert.assertNotNull(paramAnnotations[i], "paramAnnotations", new Object[0]);
            resolvers[i] = this.getDataResolver(type, annotations, this.getExtraInfo(extraInfo, method, i));
        }
        return resolvers;
    }

    private Method getAnnotatedMethod(Method method) {
        Method annotatedMethod = method;
        while (annotatedMethod != null && !this.hasAnnotations(annotatedMethod.getParameterAnnotations())) {
            annotatedMethod = this.getOverridenMethod(annotatedMethod);
        }
        return annotatedMethod == null ? method : annotatedMethod;
    }

    private boolean hasAnnotations(Annotation[][] paramAnnotations) {
        if (!ArrayUtil.isEmptyArray(paramAnnotations)) {
            for (Annotation[] annotations : paramAnnotations) {
                if (ArrayUtil.isEmptyArray(annotations)) continue;
                return true;
            }
        }
        return false;
    }

    private Method getOverridenMethod(Method method) {
        Class<?> superClass = method.getDeclaringClass().getSuperclass();
        if (superClass != null) {
            try {
                return superClass.getDeclaredMethod(method.getName(), method.getParameterTypes());
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        return null;
    }

    private Object[] getExtraInfo(Object[] extraInfo, Method method, int paramIndex) {
        Object[] result;
        if (ArrayUtil.isEmptyArray(extraInfo)) {
            result = new Object[1];
        } else {
            result = new Object[extraInfo.length + 1];
            System.arraycopy(extraInfo, 0, result, 0, extraInfo.length);
        }
        result[result.length - 1] = new MethodParameter(method, paramIndex){

            public String toString() {
                ToStringBuilder.MapBuilder mb = new ToStringBuilder.MapBuilder();
                mb.append("method", this.getMethod());
                mb.append("paramIndex", this.getParameterIndex());
                return new ToStringBuilder().append("MethodParameter").append(mb).toString();
            }
        };
        return result;
    }

    @Override
    public String toString() {
        return new ToStringBuilder().append(this.getBeanDescription()).append(this.factories).toString();
    }
}

