/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.service.dataresolver;

import com.alibaba.citrus.generictype.TypeInfo;
import com.alibaba.citrus.util.BasicConstant;
import com.alibaba.citrus.util.ToStringBuilder;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataResolverContext {
    public static final Annotation[] EMPTY_ANNOTATIONS = new Annotation[0];
    private final TypeInfo type;
    private final Annotation[] annotations;
    private final Object[] extraInfo;

    public DataResolverContext(Type type, Annotation[] annotations, Object[] extraInfo) {
        this.type = TypeInfo.factory.getType(type);
        this.annotations = annotations == null ? EMPTY_ANNOTATIONS : annotations;
        this.extraInfo = extraInfo == null ? BasicConstant.EMPTY_OBJECT_ARRAY : extraInfo;
    }

    public TypeInfo getTypeInfo() {
        return this.type;
    }

    public Annotation[] getAnnotations() {
        return this.annotations;
    }

    public Object[] getExtraInfo() {
        return this.extraInfo;
    }

    public <A extends Annotation> A getAnnotation(Class<A> type) {
        for (Annotation anno : this.annotations) {
            if (!type.isInstance(anno)) continue;
            return (A)((Annotation)type.cast(anno));
        }
        return null;
    }

    public <T> T getExtraObject(Class<T> type) {
        for (Object obj : this.extraInfo) {
            if (!type.isInstance(obj)) continue;
            return type.cast(obj);
        }
        return null;
    }

    public String toString() {
        ToStringBuilder.MapBuilder mb = new ToStringBuilder.MapBuilder();
        mb.append("type", this.type);
        mb.append("annotations", this.annotations);
        mb.append("extraInfo", this.extraInfo);
        return new ToStringBuilder().append(this.getClass().getSimpleName()).append(mb).toString();
    }
}

