/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.generictype.impl;

import com.alibaba.citrus.generictype.GenericDeclarationInfo;
import com.alibaba.citrus.generictype.TypeInfo;
import com.alibaba.citrus.generictype.TypeVariableInfo;
import com.alibaba.citrus.generictype.impl.TypeInfoFactory;
import com.alibaba.citrus.util.Assert;
import com.alibaba.citrus.util.CollectionUtil;
import java.lang.reflect.GenericDeclaration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractGenericDeclarationInfo
implements GenericDeclarationInfo {
    protected final GenericDeclaration declaration;
    private List<TypeVariableInfo> parameters;

    AbstractGenericDeclarationInfo(GenericDeclaration declaration) {
        this.declaration = Assert.assertNotNull(declaration, "declaration", new Object[0]);
    }

    void init(TypeVariableInfo[] vars) {
        this.parameters = Collections.unmodifiableList(CollectionUtil.asList(vars));
    }

    @Override
    public boolean isGeneric() {
        return !this.parameters.isEmpty();
    }

    @Override
    public List<TypeVariableInfo> getTypeParameters() {
        return this.parameters;
    }

    @Override
    public List<TypeInfo> getActualTypeArguments() {
        List<TypeVariableInfo> vars = this.getTypeParameters();
        ArrayList<TypeInfo> actualArgs = CollectionUtil.createArrayList(vars.size());
        for (TypeVariableInfo var : vars) {
            actualArgs.add(TypeInfoFactory.findNonBoundedType(var));
        }
        return actualArgs;
    }

    @Override
    public TypeInfo getActualTypeArgument(String name) {
        for (TypeVariableInfo var : this.getTypeParameters()) {
            if (!var.getName().equals(name)) continue;
            return TypeInfoFactory.findNonBoundedType(var);
        }
        return null;
    }

    public int hashCode() {
        return this.getClass().hashCode() ^ this.declaration.hashCode();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null || !other.getClass().equals(this.getClass())) {
            return false;
        }
        AbstractGenericDeclarationInfo otherDecl = (AbstractGenericDeclarationInfo)other;
        return this.declaration.equals(otherDecl.declaration);
    }

    public abstract String toString();

    protected int appendTypeParameters(StringBuilder buf) {
        int length = buf.length();
        if (this.isGeneric()) {
            buf.append("<");
            CollectionUtil.join(buf, this.parameters, ", ");
            buf.append(">");
        }
        return buf.length() - length;
    }
}

