/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.dev.handler.component;

import com.alibaba.citrus.util.Assert;
import com.alibaba.citrus.util.CollectionUtil;
import com.alibaba.citrus.util.StringEscapeUtil;
import com.alibaba.citrus.util.StringUtil;
import com.alibaba.citrus.util.internal.webpagelite.PageComponent;
import com.alibaba.citrus.util.internal.webpagelite.PageComponentRegistry;
import com.alibaba.citrus.util.templatelite.Template;
import com.alibaba.citrus.webx.handler.RequestHandlerContext;
import com.alibaba.citrus.webx.handler.support.AbstractVisitor;
import java.io.PrintWriter;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TabsComponent
extends PageComponent {
    public TabsComponent(PageComponentRegistry registry, String componentPath) {
        super(registry, componentPath);
    }

    public void visitTemplate(RequestHandlerContext context, List<TabItem> tabs) {
        this.getTemplate().accept(new TabsVisitor(context, tabs));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TabItem {
        private final String escapedDesc;
        private String href;
        private String onclick;
        private boolean selected;
        private final List<TabItem> subtabs = CollectionUtil.createLinkedList();

        public TabItem(String desc) {
            this(desc, false);
        }

        public TabItem(String desc, boolean escaped) {
            this.escapedDesc = escaped ? StringUtil.trimToNull(desc) : StringEscapeUtil.escapeHtml(StringUtil.trimToNull(desc));
        }

        public String getEscapedDesc() {
            return this.escapedDesc;
        }

        public String getHref() {
            return StringUtil.trimToNull(this.href);
        }

        public void setHref(String href) {
            this.href = StringUtil.trimToNull(href);
        }

        public String getOnclick() {
            return this.onclick;
        }

        public void setOnclick(String onclick) {
            this.onclick = StringUtil.trimToNull(onclick);
        }

        public boolean isSelected() {
            return this.selected;
        }

        public void setSelected(boolean selected) {
            this.selected = selected;
        }

        public List<TabItem> getSubTabs() {
            return this.subtabs;
        }

        public void addSubTab(TabItem tab) {
            this.subtabs.add(tab);
        }
    }

    private class TabVisitor
    extends AbstractVisitor {
        private final TabItem tab;

        public TabVisitor(RequestHandlerContext context, TabItem tab) {
            super(context, TabsComponent.this);
            this.tab = Assert.assertNotNull(tab, "tab", new Object[0]);
        }

        public void visitSelectedAttr(Template selectedTemplate) {
            if (this.tab.isSelected()) {
                selectedTemplate.accept(this);
            }
        }

        public void visitLinkAttrs(Template hrefTemplate, Template onclickTemplate) {
            if (this.tab.getHref() != null) {
                hrefTemplate.accept(this);
            }
            if (this.tab.getOnclick() != null) {
                onclickTemplate.accept(this);
            }
        }

        public void visitHrefLink() {
            ((PrintWriter)this.out()).print(StringEscapeUtil.escapeHtml(this.tab.getHref()));
        }

        public void visitOnclickScript() {
            ((PrintWriter)this.out()).print(StringEscapeUtil.escapeHtml(this.tab.getOnclick()));
        }

        public void visitDesc() {
            if (this.tab.getEscapedDesc() != null) {
                ((PrintWriter)this.out()).print(this.tab.getEscapedDesc());
            }
        }

        public void visitSubnav(Template subnavTemplate) {
            if (!this.tab.getSubTabs().isEmpty()) {
                subnavTemplate.accept(this);
            }
        }

        public void visitSubtabs(Template tabTemplate) {
            new TabsVisitor(this.context, this.tab.getSubTabs()).visitTab(tabTemplate);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TabsVisitor
    extends AbstractVisitor {
        private final List<TabItem> tabs;

        public TabsVisitor(RequestHandlerContext context, List<TabItem> tabs) {
            super(context, TabsComponent.this);
            this.tabs = Assert.assertNotNull(tabs, "tabs", new Object[0]);
        }

        public void visitTab(Template tabTemplate) {
            for (TabItem tab : this.tabs) {
                tabTemplate.accept(new TabVisitor(this.context, tab));
            }
        }
    }
}

