/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.async.pipeline.valve;

import com.alibaba.citrus.async.AsyncCallback;
import com.alibaba.citrus.util.Assert;
import java.util.concurrent.Callable;
import javax.servlet.AsyncContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AsyncCallbackAdapter
implements Callable<Object>,
AsyncCallback {
    private final long defaultTimeout;
    private final long defaultCancelingTimeout;
    private final Object runnable;
    private final AsyncContext asyncContext;

    AsyncCallbackAdapter(Object runnable, AsyncContext asyncContext, long defaultTimeout, long defaultCancelingTimeout) {
        Assert.assertTrue(runnable instanceof Runnable || runnable instanceof Callable, "runnable or callable", new Object[0]);
        this.runnable = runnable;
        this.asyncContext = Assert.assertNotNull(asyncContext, "asyncContext", new Object[0]);
        this.defaultTimeout = defaultTimeout;
        this.defaultCancelingTimeout = defaultCancelingTimeout;
    }

    @Override
    public long getTimeout() {
        long timeout = -1L;
        if (this.runnable instanceof AsyncCallback) {
            timeout = ((AsyncCallback)this.runnable).getTimeout();
        }
        if (timeout < 0L) {
            timeout = this.defaultTimeout;
        }
        return timeout;
    }

    @Override
    public long getCancelingTimeout() {
        long timeout = -1L;
        if (this.runnable instanceof AsyncCallback) {
            timeout = ((AsyncCallback)this.runnable).getCancelingTimeout();
        }
        if (timeout < 0L) {
            timeout = this.defaultCancelingTimeout;
        }
        return timeout;
    }

    public AsyncContext getAsyncContext() {
        return this.asyncContext;
    }

    @Override
    public Object call() throws Exception {
        if (this.runnable instanceof Runnable) {
            ((Runnable)this.runnable).run();
            return null;
        }
        return ((Callable)this.runnable).call();
    }
}

