/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.turbine.pipeline.valve;

import com.alibaba.citrus.service.mappingrule.MappingRuleService;
import com.alibaba.citrus.service.moduleloader.Module;
import com.alibaba.citrus.service.moduleloader.ModuleEvent;
import com.alibaba.citrus.service.moduleloader.ModuleLoaderException;
import com.alibaba.citrus.service.moduleloader.ModuleLoaderService;
import com.alibaba.citrus.service.moduleloader.ModuleNotFoundException;
import com.alibaba.citrus.service.moduleloader.ModuleReturningValue;
import com.alibaba.citrus.service.pipeline.PipelineContext;
import com.alibaba.citrus.service.pipeline.support.AbstractValveDefinitionParser;
import com.alibaba.citrus.springext.util.SpringExtUtil;
import com.alibaba.citrus.turbine.TurbineRunData;
import com.alibaba.citrus.turbine.pipeline.valve.AbstractInputOutputValve;
import com.alibaba.citrus.turbine.util.TurbineUtil;
import com.alibaba.citrus.util.Assert;
import com.alibaba.citrus.util.StringUtil;
import com.alibaba.citrus.util.internal.ScreenEventUtil;
import com.alibaba.citrus.webx.WebxException;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public class PerformScreenValve
extends AbstractInputOutputValve {
    @Autowired
    private ModuleLoaderService moduleLoaderService;
    @Autowired
    private HttpServletRequest request;
    @Autowired
    private MappingRuleService mappingRuleService;

    public MappingRuleService getMappingRuleService() {
        return this.mappingRuleService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(PipelineContext pipelineContext) throws Exception {
        TurbineRunData rundata = TurbineUtil.getTurbineRunData(this.request);
        if (!rundata.isRedirected()) {
            this.setContentType(rundata);
            Object result = null;
            try {
                result = this.performScreenModule(rundata);
            }
            finally {
                this.setOutputValue(pipelineContext, result);
            }
        }
        pipelineContext.invokeNext();
    }

    protected void setContentType(TurbineRunData rundata) {
        if (StringUtil.isEmpty(rundata.getResponse().getContentType())) {
            rundata.getResponse().setContentType("text/html");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Object performScreenModule(TurbineRunData rundata) {
        ModuleFinder finder = new ModuleFinder(rundata.getTarget());
        rundata.setLayoutEnabled(true);
        try {
            Module module = finder.getScreenModule();
            if (module == null) {
                if (!this.isScreenModuleRequired()) return null;
                throw new ModuleNotFoundException("Could not find screen module: " + finder.moduleName);
            }
            ScreenEventUtil.setEventName(rundata.getRequest(), finder.event);
            try {
                if (module instanceof ModuleReturningValue) {
                    Object object = ((ModuleReturningValue)module).executeAndReturn();
                    return object;
                }
                module.execute();
                return null;
            }
            finally {
                ScreenEventUtil.setEventName(rundata.getRequest(), null);
            }
        }
        catch (ModuleLoaderException e) {
            throw new WebxException("Failed to load screen module: " + finder.moduleName, e);
        }
        catch (Exception e) {
            throw new WebxException("Failed to execute screen: " + finder.moduleName, e);
        }
    }

    protected boolean isScreenModuleRequired() {
        return true;
    }

    protected String getModuleName(String target) {
        return this.mappingRuleService.getMappedName("screen.notemplate", target);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DefinitionParser
    extends AbstractValveDefinitionParser<PerformScreenValve> {
        protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
            SpringExtUtil.attributesToProperties(element, builder, "output");
        }
    }

    private class ModuleFinder {
        private final String target;
        private String moduleName;
        private String eventModuleName;
        private String event;

        public ModuleFinder(String target) {
            this.target = Assert.assertNotNull(target, "Target was not specified", new Object[0]);
        }

        public Module getScreenModule() throws ModuleLoaderException {
            this.moduleName = PerformScreenValve.this.getModuleName(this.target);
            Module module = PerformScreenValve.this.moduleLoaderService.getModuleQuiet("screen", this.moduleName);
            if (module != null) {
                return module;
            }
            if (this.parseEvent() && (module = PerformScreenValve.this.moduleLoaderService.getModuleQuiet("screen", this.eventModuleName)) instanceof ModuleEvent) {
                return module;
            }
            return null;
        }

        private boolean parseEvent() {
            int slashIndex = this.target.lastIndexOf("/");
            int dotIndex = this.target.lastIndexOf(".");
            if (slashIndex > 0) {
                this.event = this.target.substring(slashIndex + 1, dotIndex > slashIndex ? dotIndex : this.target.length());
                this.eventModuleName = PerformScreenValve.this.getModuleName(this.target.substring(0, slashIndex));
                return true;
            }
            return false;
        }
    }
}

