/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.turbine.auth.impl;

import com.alibaba.citrus.turbine.auth.impl.AuthGrant;
import com.alibaba.citrus.turbine.auth.impl.AuthPattern;
import com.alibaba.citrus.turbine.auth.impl.AuthTargetPattern;
import com.alibaba.citrus.util.ObjectUtil;
import com.alibaba.citrus.util.ToStringBuilder;

public class AuthMatch {
    private static final AuthGrant[] NO_GRANTS = new AuthGrant[0];
    private final AuthPattern pattern;
    private final AuthGrant[] grants;

    public AuthMatch(String pattern, AuthGrant[] grants) {
        this.pattern = new AuthTargetPattern(pattern);
        this.grants = ObjectUtil.defaultIfNull(grants, NO_GRANTS);
    }

    public AuthPattern getPattern() {
        return this.pattern;
    }

    public AuthGrant[] getGrants() {
        return this.grants;
    }

    public String toString() {
        return this.toString(-1);
    }

    public String toString(int matchedGrantIndex) {
        ToStringBuilder.MapBuilder mb = new ToStringBuilder.MapBuilder();
        mb.append("pattern", this.pattern);
        if (matchedGrantIndex < 0 || matchedGrantIndex >= this.grants.length) {
            mb.append("grants", this.grants);
        } else {
            mb.append("grants[" + matchedGrantIndex + "]", this.grants[matchedGrantIndex]);
        }
        return new ToStringBuilder().append("Match").append(mb).toString();
    }
}

