/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.springext.support;

import com.alibaba.citrus.springext.ConfigurationPoint;
import com.alibaba.citrus.springext.ConfigurationPoints;
import com.alibaba.citrus.springext.Contribution;
import com.alibaba.citrus.springext.ResourceResolver;
import com.alibaba.citrus.springext.Schema;
import com.alibaba.citrus.springext.Schemas;
import com.alibaba.citrus.springext.impl.ConfigurationPointImpl;
import com.alibaba.citrus.springext.impl.ConfigurationPointsImpl;
import com.alibaba.citrus.springext.impl.SpringPluggableSchemas;
import com.alibaba.citrus.springext.support.ConfigurationPointSchemaSourceInfo;
import com.alibaba.citrus.springext.support.ContributionSchemaSourceInfo;
import com.alibaba.citrus.springext.support.SchemaSet;
import com.alibaba.citrus.springext.support.SchemaUtil;
import com.alibaba.citrus.springext.support.SpringPluggableSchemaSourceInfo;
import com.alibaba.citrus.util.Assert;
import com.alibaba.citrus.util.CollectionUtil;
import com.alibaba.citrus.util.ToStringBuilder;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpringExtSchemaSet
extends SchemaSet {
    private NamespaceItem[] allItems;
    private NamespaceItem[] treeItems;
    private NamespaceItem[] treeItemsWithAllContributions;
    private Map<String, IncludedSchemaInfo> includedSchemaInfoMap;

    public SpringExtSchemaSet() {
        this(new ConfigurationPointsImpl(), new SpringPluggableSchemas());
    }

    public SpringExtSchemaSet(ClassLoader classLoader) {
        this(new ConfigurationPointsImpl(classLoader), new SpringPluggableSchemas(classLoader));
    }

    public SpringExtSchemaSet(ResourceResolver resourceResolver) {
        this(new ConfigurationPointsImpl(resourceResolver), new SpringPluggableSchemas(resourceResolver));
    }

    SpringExtSchemaSet(String location) {
        this(new ConfigurationPointsImpl((ClassLoader)null, location), new SpringPluggableSchemas());
    }

    private SpringExtSchemaSet(ConfigurationPointsImpl configurationPoints, SpringPluggableSchemas springPluggableSchemas) {
        super(configurationPoints, springPluggableSchemas);
    }

    public ConfigurationPoints getConfigurationPoints() {
        for (Schemas schemas : this) {
            if (!(schemas instanceof ConfigurationPoints)) continue;
            return (ConfigurationPoints)schemas;
        }
        Assert.unreachableCode("no ConfigurationPoints found", new Object[0]);
        return null;
    }

    @Override
    protected void foundIncludes(Schema schema, Collection<Schema> allIncludes) {
        Contribution contribution;
        if (schema instanceof ContributionSchemaSourceInfo && (contribution = (Contribution)((ContributionSchemaSourceInfo)((Object)schema)).getParent()) != null) {
            for (Schema includedSchema : allIncludes) {
                String includedSchemaName;
                IncludedSchemaInfo includedSchemaInfo;
                if (!(includedSchema instanceof SpringPluggableSchemaSourceInfo)) continue;
                if (this.includedSchemaInfoMap == null) {
                    this.includedSchemaInfoMap = CollectionUtil.createHashMap();
                }
                if ((includedSchemaInfo = this.includedSchemaInfoMap.get(includedSchemaName = includedSchema.getName())) == null) {
                    includedSchemaInfo = new IncludedSchemaInfo(includedSchema);
                    this.includedSchemaInfoMap.put(includedSchemaName, includedSchemaInfo);
                }
                includedSchemaInfo.includingContributions.put(schema.getName(), contribution);
            }
        }
    }

    @Override
    protected void finishProcessIncludes() {
        if (this.includedSchemaInfoMap != null) {
            for (final IncludedSchemaInfo includedSchemaInfo : this.includedSchemaInfoMap.values()) {
                Schema includedSchema = includedSchemaInfo.getIncludedSchema();
                includedSchema.transform(SchemaUtil.getAnyElementTransformer(this.getConfigurationPoints(), new SchemaUtil.AnyElementVisitor(){

                    public void visitAnyElement(ConfigurationPoint cp) {
                        for (Contribution contribution : includedSchemaInfo) {
                            if (!(cp instanceof ConfigurationPointImpl)) continue;
                            ((ConfigurationPointImpl)cp).addDependingContribution(contribution);
                        }
                    }
                }), true);
            }
        }
        this.includedSchemaInfoMap = null;
    }

    public NamespaceItem[] getAllItems() {
        this.ensureTreeBuilt(false);
        return this.allItems;
    }

    public NamespaceItem[] getIndependentItems() {
        return this.getIndependentItems(false);
    }

    public NamespaceItem[] getIndependentItems(boolean includingAllContributions) {
        this.ensureTreeBuilt(includingAllContributions);
        return includingAllContributions ? this.treeItemsWithAllContributions : this.treeItems;
    }

    private synchronized void ensureTreeBuilt(boolean includingAllContributions) {
        if (this.allItems == null || (includingAllContributions ? this.treeItemsWithAllContributions : this.treeItems) == null) {
            TreeBuilder builder = new TreeBuilder().build(includingAllContributions);
            if (this.allItems == null) {
                this.allItems = builder.getAllNamespaceItems();
            }
            if (includingAllContributions) {
                if (this.treeItemsWithAllContributions == null) {
                    this.treeItemsWithAllContributions = builder.getIndependentNamespaceItems();
                }
            } else if (this.treeItems == null) {
                this.treeItems = builder.getIndependentNamespaceItems();
            }
        }
    }

    protected ConfigurationPointItem createConfigurationPointItem(String namespace, Set<Schema> schemas, ConfigurationPoint configurationPoint) {
        return new ConfigurationPointItem(namespace, schemas, configurationPoint);
    }

    protected ContributionItem createContributionItem(Contribution contribution) {
        return new ContributionItem(contribution);
    }

    protected SpringPluggableItem createSpringPluggableItem(String namespace, Set<Schema> schemas) {
        return new SpringPluggableItem(namespace, schemas);
    }

    protected <C extends TreeItem> void addChildItem(ParentOf<C> parent, String key, C childItem) {
        parent.getChildrenMap().put(key, childItem);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TreeBuilder {
        private final Map<String, Set<Schema>> namespaceMappings;
        private final Map<String, NamespaceItem> items;
        private final Map<String, NamespaceItem> independentItems;
        private final LinkedList<String> buildingNamespaces;
        private boolean includingAllContributions;

        private TreeBuilder() {
            this.namespaceMappings = SpringExtSchemaSet.this.getNamespaceMappings();
            this.items = CollectionUtil.createTreeMap();
            this.independentItems = CollectionUtil.createTreeMap();
            this.buildingNamespaces = CollectionUtil.createLinkedList();
        }

        public TreeBuilder build(boolean includingAllContributions) {
            this.includingAllContributions = includingAllContributions;
            for (String namespace : this.namespaceMappings.keySet()) {
                this.buildNamespaceItemRecursively(namespace);
            }
            return this;
        }

        public NamespaceItem[] getAllNamespaceItems() {
            return this.items.values().toArray(new NamespaceItem[this.items.size()]);
        }

        public NamespaceItem[] getIndependentNamespaceItems() {
            return this.independentItems.values().toArray(new NamespaceItem[this.independentItems.size()]);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean buildNamespaceItemRecursively(String namespace) {
            if (this.buildingNamespaces.contains(namespace)) {
                return false;
            }
            try {
                this.buildingNamespaces.push(namespace);
                this.buildNamespaceItem(namespace);
            }
            finally {
                this.buildingNamespaces.pop();
            }
            return true;
        }

        private void buildNamespaceItem(String namespace) {
            if (this.items.containsKey(namespace)) {
                return;
            }
            Set<Schema> schemas = this.namespaceMappings.get(namespace);
            Assert.assertTrue(schemas != null, "%s not exist", namespace);
            Schema schema = null;
            if (!schemas.isEmpty()) {
                schema = schemas.iterator().next();
            }
            if (schema == null || schema instanceof SpringPluggableSchemaSourceInfo) {
                this.buildSpringPluggableItem(namespace, schemas);
            } else if (schema instanceof ConfigurationPointSchemaSourceInfo) {
                this.buildConfigurationPointItem(namespace, schemas, (ConfigurationPointSchemaSourceInfo)((Object)schema));
            } else {
                Assert.unreachableCode();
            }
        }

        private void buildSpringPluggableItem(String namespace, Set<Schema> schemas) {
            SpringPluggableItem item = SpringExtSchemaSet.this.createSpringPluggableItem(namespace, schemas);
            this.items.put(namespace, item);
            this.independentItems.put(namespace, item);
        }

        private void buildConfigurationPointItem(String namespace, Set<Schema> schemas, ConfigurationPointSchemaSourceInfo schema) {
            ConfigurationPoint configurationPoint = (ConfigurationPoint)schema.getParent();
            ConfigurationPointItem item = SpringExtSchemaSet.this.createConfigurationPointItem(namespace, schemas, configurationPoint);
            this.items.put(namespace, item);
            if (this.includingAllContributions) {
                for (Contribution contribution : configurationPoint.getContributions()) {
                    ContributionItem contributionItem = SpringExtSchemaSet.this.createContributionItem(contribution);
                    SpringExtSchemaSet.this.addChildItem(item, contribution.getName(), contributionItem);
                }
            }
            int count = 0;
            for (Contribution contribution : configurationPoint.getDependingContributions()) {
                String dependingNamespace = contribution.getConfigurationPoint().getNamespaceUri();
                if (!this.buildNamespaceItemRecursively(dependingNamespace)) continue;
                ++count;
                NamespaceItem parentItem = Assert.assertNotNull(this.items.get(dependingNamespace), "no item for namespace %s", namespace);
                if (!(parentItem instanceof ConfigurationPointItem)) continue;
                this.buildContributionItem(namespace, item, contribution, (ConfigurationPointItem)parentItem);
            }
            if (count == 0) {
                this.independentItems.put(namespace, item);
            }
        }

        private void buildContributionItem(String namespace, ConfigurationPointItem item, Contribution contribution, ConfigurationPointItem parentItem) {
            String contributionName = contribution.getName();
            ContributionItem parentContributionItem = (ContributionItem)parentItem.getChildrenMap().get(contributionName);
            if (parentContributionItem == null) {
                parentContributionItem = SpringExtSchemaSet.this.createContributionItem(contribution);
                SpringExtSchemaSet.this.addChildItem(parentItem, contributionName, parentContributionItem);
            }
            if (!parentContributionItem.getChildrenMap().containsKey(namespace)) {
                SpringExtSchemaSet.this.addChildItem(parentContributionItem, namespace, item);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class AbstractNamespaceItem<C extends TreeItem>
    extends AbstractTreeItem<C>
    implements NamespaceItem {
        private final String namespace;
        private final Set<Schema> schemas;

        protected AbstractNamespaceItem(Class<C> childType, String namespace, Set<Schema> schemas) {
            super(childType);
            this.namespace = namespace;
            this.schemas = schemas;
        }

        @Override
        public String getNamespace() {
            return this.namespace;
        }

        @Override
        public Set<Schema> getSchemas() {
            return this.schemas;
        }

        public String toString() {
            return this.namespace;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class AbstractTreeItem<C extends TreeItem>
    implements TreeItem,
    ParentOf<C> {
        protected final Map<String, C> children = CollectionUtil.createTreeMap();
        private final Class<C> childType;

        protected AbstractTreeItem(Class<C> childType) {
            this.childType = Assert.assertNotNull(childType, "child item type", new Object[0]);
        }

        @Override
        public boolean hasChildren() {
            return !this.children.isEmpty();
        }

        public C[] getChildren() {
            TreeItem[] copy = (TreeItem[])Array.newInstance(this.childType, this.children.size());
            return this.children.values().toArray(copy);
        }

        @Override
        public Map<String, C> getChildrenMap() {
            return this.children;
        }

        public String dump() {
            ToStringBuilder buf = new ToStringBuilder();
            this.dump(buf);
            return buf.toString();
        }

        void dump(ToStringBuilder buf) {
            buf.append(this).start("{", "}");
            int i = 0;
            for (TreeItem child : this.getChildren()) {
                if (i++ > 0) {
                    buf.append("\n");
                }
                ((AbstractTreeItem)child).dump(buf);
            }
            buf.end();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SpringPluggableItem
    extends AbstractNamespaceItem<TreeItem> {
        public SpringPluggableItem(String namespace, Set<Schema> schemas) {
            super(TreeItem.class, namespace, schemas);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ContributionItem
    extends AbstractTreeItem<ConfigurationPointItem> {
        private final Contribution contribution;

        public ContributionItem(Contribution contribution) {
            super(ConfigurationPointItem.class);
            this.contribution = contribution;
        }

        public Contribution getContribution() {
            return this.contribution;
        }

        public String toString() {
            return this.contribution.getName();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ConfigurationPointItem
    extends AbstractNamespaceItem<ContributionItem> {
        private final ConfigurationPoint configurationPoint;

        public ConfigurationPointItem(String namespace, Set<Schema> schemas, ConfigurationPoint configurationPoint) {
            super(ContributionItem.class, namespace, schemas);
            this.configurationPoint = configurationPoint;
        }

        public ConfigurationPoint getConfigurationPoint() {
            return this.configurationPoint;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ParentOf<C extends TreeItem> {
        public Map<String, C> getChildrenMap();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface NamespaceItem
    extends TreeItem {
        public String getNamespace();

        public Set<Schema> getSchemas();
    }

    public static interface TreeItem {
        public boolean hasChildren();

        public TreeItem[] getChildren();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class IncludedSchemaInfo
    implements Iterable<Contribution> {
        private final Map<String, Contribution> includingContributions = CollectionUtil.createHashMap();
        private final Schema includedSchema;

        private IncludedSchemaInfo(Schema includedSchema) {
            this.includedSchema = includedSchema;
        }

        public Schema getIncludedSchema() {
            return this.includedSchema;
        }

        @Override
        public Iterator<Contribution> iterator() {
            return this.includingContributions.values().iterator();
        }
    }
}

